/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

final class NarrowTab {
    NarrowTab() {
    }

    JComponent build() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "pref, 14dlu, pref, 14dlu, pref, 0:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.getPanel().setOpaque(false);
        CellConstraints cc = new CellConstraints();
        builder.add(this.buildButtonBoxNoNarrow(), cc.xy(1, 1));
        builder.add(this.buildButtonFormNoNarrow(), cc.xy(1, 3));
        builder.add(this.buildButtonGridNoNarrow(), cc.xy(1, 5));
        return builder.getPanel();
    }

    private Component buildButtonBoxNoNarrow() {
        return this.buildButtonBox(this.createButtons());
    }

    private Component buildButtonBox(JButton[] buttons) {
        Box box = Box.createHorizontalBox();
        for (int i = 0; i < buttons.length; ++i) {
            box.add(buttons[i]);
            box.add(Box.createHorizontalStrut(6));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        panel.setOpaque(false);
        panel.setBorder(new CompoundBorder(new TitledBorder("Raw Button Widths (BoxLayout)"), new EmptyBorder(14, 14, 14, 14)));
        return panel;
    }

    private Component buildButtonFormNoNarrow() {
        JButton[] buttons = this.createButtons();
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.getPanel().setOpaque(false);
        for (int i = 0; i < buttons.length - 1; ++i) {
            builder.addGridded(buttons[i]);
            builder.addRelatedGap();
        }
        builder.addFixed(buttons[buttons.length - 1]);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)builder.getPanel(), "Center");
        panel.setOpaque(false);
        panel.setBorder(new CompoundBorder(new TitledBorder("Adjusted Button Widths (FormLayout)"), new EmptyBorder(14, 14, 14, 14)));
        return panel;
    }

    private Component buildButtonGridNoNarrow() {
        return this.buildButtonGrid(this.createButtons());
    }

    private Component buildButtonGrid(JButton[] buttons) {
        JPanel grid = new JPanel(new GridLayout(1, 4, 6, 0));
        grid.setOpaque(false);
        for (int i = 0; i < buttons.length; ++i) {
            grid.add(buttons[i]);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)grid, "Center");
        panel.setOpaque(false);
        panel.setBorder(new CompoundBorder(new TitledBorder("Equalized Button Widths (GridLayout)"), new EmptyBorder(14, 14, 14, 14)));
        return panel;
    }

    private JButton[] createButtons() {
        return new JButton[]{new JButton("Add\u2026"), new JButton("Remove"), new JButton("Up"), new JButton("Down"), new JButton("Copy to Clipboard")};
    }
}

