/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView mapView) {
        super(mapView);
    }

    public boolean add(Object mapEntry) {
        Map.Entry entry = (Map.Entry)mapEntry;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object mapEntry) {
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.getSearchBoth(entry.getKey(), entry.getValue(), true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean contains(Object mapEntry) {
        boolean bl;
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.getSearchBoth(entry.getKey(), entry.getValue(), false);
            bl = status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (buf.length() > 1) {
                    buf.append(',');
                }
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    buf.append(key.toString());
                }
                buf.append('=');
                if (val == null) continue;
                buf.append(val.toString());
            }
            buf.append(']');
            String string = buf.toString();
            return string;
        }
        finally {
            StoredIterator.close(i);
        }
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DatabaseException {
        return new StoredMapEntry(cursor.getCurrentKey(), cursor.getCurrentValue(), this, iterator);
    }

    boolean hasValues() {
        return true;
    }
}

