/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import java.nio.ByteBuffer;

public class FileSummary
implements LogWritable,
LogReadable {
    private static final int MIN_FILES_FOR_AGING = 10;
    public int totalCount;
    public int totalSize;
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int obsoleteINCount;
    public int obsoleteLNCount;

    public boolean isEmpty() {
        return this.totalCount == 0 && this.totalSize == 0 && this.obsoleteINCount == 0 && this.obsoleteLNCount == 0;
    }

    public int getObsoleteLNSize() {
        if (this.totalLNCount == 0) {
            return 0;
        }
        long totalSize = this.totalLNSize;
        long avgSizePerLN = (totalSize <<= 8) / (long)this.totalLNCount;
        return (int)((long)this.obsoleteLNCount * avgSizePerLN >> 8);
    }

    public int getObsoleteINSize() {
        if (this.totalINCount == 0) {
            return 0;
        }
        long totalSize = this.totalINSize;
        long avgSizePerIN = (totalSize <<= 8) / (long)this.totalINCount;
        return (int)((long)this.obsoleteINCount * avgSizePerIN >> 8);
    }

    public int getObsoleteSize() throws DatabaseException {
        if (this.totalSize > 0) {
            int leftoverSize = this.totalSize - (this.totalINSize + this.totalLNSize);
            return this.getObsoleteLNSize() + this.getObsoleteINSize() + leftoverSize;
        }
        return 0;
    }

    public int getEntriesCounted() {
        return this.totalCount + this.obsoleteLNCount + this.obsoleteINCount;
    }

    public int getNonObsoleteCount() {
        return this.totalLNCount + this.totalINCount - this.obsoleteLNCount - this.obsoleteINCount;
    }

    public void reset() {
        this.totalCount = 0;
        this.totalSize = 0;
        this.totalINCount = 0;
        this.totalINSize = 0;
        this.totalLNCount = 0;
        this.totalLNSize = 0;
        this.obsoleteINCount = 0;
        this.obsoleteLNCount = 0;
    }

    public void add(FileSummary o) {
        this.totalCount += o.totalCount;
        this.totalSize += o.totalSize;
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        this.obsoleteINCount += o.obsoleteINCount;
        this.obsoleteLNCount += o.obsoleteLNCount;
    }

    public int getLogSize() {
        return 8 * LogUtils.getIntLogSize();
    }

    public void writeToLog(ByteBuffer buf) {
        LogUtils.writeInt(buf, this.totalCount);
        LogUtils.writeInt(buf, this.totalSize);
        LogUtils.writeInt(buf, this.totalINCount);
        LogUtils.writeInt(buf, this.totalINSize);
        LogUtils.writeInt(buf, this.totalLNCount);
        LogUtils.writeInt(buf, this.totalLNSize);
        LogUtils.writeInt(buf, this.obsoleteINCount);
        LogUtils.writeInt(buf, this.obsoleteLNCount);
    }

    public void readFromLog(ByteBuffer buf, byte entryTypeVersion) {
        this.totalCount = LogUtils.readInt(buf);
        this.totalSize = LogUtils.readInt(buf);
        this.totalINCount = LogUtils.readInt(buf);
        this.totalINSize = LogUtils.readInt(buf);
        this.totalLNCount = LogUtils.readInt(buf);
        this.totalLNSize = LogUtils.readInt(buf);
        this.obsoleteINCount = LogUtils.readInt(buf);
        if (this.obsoleteINCount == -1) {
            this.obsoleteINCount = this.totalINCount;
        }
        this.obsoleteLNCount = LogUtils.readInt(buf);
    }

    public void dumpLog(StringBuffer buf, boolean verbose) {
        buf.append("<summary totalCount=\"");
        buf.append(this.totalCount);
        buf.append("\" totalSize=\"");
        buf.append(this.totalSize);
        buf.append("\" totalINCount=\"");
        buf.append(this.totalINCount);
        buf.append("\" totalINSize=\"");
        buf.append(this.totalINSize);
        buf.append("\" totalLNCount=\"");
        buf.append(this.totalLNCount);
        buf.append("\" totalLNSize=\"");
        buf.append(this.totalLNSize);
        buf.append("\" obsoleteINCount=\"");
        buf.append(this.obsoleteINCount);
        buf.append("\" obsoleteLNCount=\"");
        buf.append(this.obsoleteLNCount);
        buf.append("\"/>");
    }

    public long getTransactionId() {
        return -1L;
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dumpLog(buf, true);
        return buf.toString();
    }
}

