/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public class UtilizationProfile {
    private EnvironmentImpl env;
    private UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap fileSummaryMap;
    private boolean cachePopulated;
    private boolean rmwFixEnabled;
    private int minUtilization;
    private int minAge;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) throws DatabaseException {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap();
        this.minAge = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    synchronized int getNumberOfFiles() throws DatabaseException {
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        return this.fileSummaryMap.size();
    }

    synchronized Long getCheapestFileToClean(List files) throws DatabaseException {
        if (files.size() == 1) {
            return (Long)files.get(0);
        }
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        Long bestFile = null;
        int bestCost = Integer.MAX_VALUE;
        for (int i = 0; i < files.size(); ++i) {
            Long file = (Long)files.get(i);
            long fileNum = file;
            FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
            summary = this.addTrackedSummary(summary, fileNum);
            int thisCost = summary.getNonObsoleteCount();
            if (bestFile != null && thisCost >= bestCost) continue;
            bestFile = file;
            bestCost = thisCost;
        }
        return bestFile;
    }

    synchronized Long getBestFileForCleaning(FileSelector fileSelector, boolean forceCleaning, Set lowUtilizationFiles) throws DatabaseException {
        if (lowUtilizationFiles != null) {
            lowUtilizationFiles.clear();
        }
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        if (this.fileSummaryMap.size() == 0) {
            return null;
        }
        long firstActiveLsn = this.env.getCheckpointer().getFirstActiveLsn();
        if (firstActiveLsn == -1L) {
            return null;
        }
        Iterator iter = this.fileSummaryMap.keySet().iterator();
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        while (iter.hasNext()) {
            Long file = (Long)iter.next();
            long fileNum = file;
            FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
            summary = this.addTrackedSummary(summary, fileNum);
            int obsoleteSize = summary.getObsoleteSize();
            if (fileSelector.isFileCleaningInProgress(file)) {
                totalSize += (long)(summary.totalSize - obsoleteSize);
                continue;
            }
            totalObsoleteSize += (long)obsoleteSize;
            totalSize += (long)summary.totalSize;
            if (DbLsn.getFileNumber(firstActiveLsn) - fileNum < (long)this.minAge) continue;
            int thisUtilization = UtilizationProfile.utilization(obsoleteSize, summary.totalSize);
            if (bestFile == null || thisUtilization < bestUtilization) {
                bestFile = file;
                bestUtilization = thisUtilization;
            }
            if (lowUtilizationFiles == null || thisUtilization >= this.minUtilization) continue;
            lowUtilizationFiles.add(file);
        }
        int totalUtilization = UtilizationProfile.utilization(totalObsoleteSize, totalSize);
        if (forceCleaning || totalUtilization < this.minUtilization) {
            return bestFile;
        }
        return null;
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize != 0L) {
            return (int)((totalSize - obsoleteSize) * 100L / totalSize);
        }
        return 0;
    }

    private FileSummary addTrackedSummary(FileSummary summary, long fileNum) {
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public void countAndLogSummaries(TrackedFileSummary[] summaries) throws DatabaseException {
        this.env.getLogManager().countObsoleteNodes(summaries);
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (int i = 0; i < summaries.length; ++i) {
            long fileNum = summaries[i].getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    public synchronized SortedMap getFileSummaryMap(boolean includeTrackedFiles) throws DatabaseException {
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            Iterator iter = this.fileSummaryMap.keySet().iterator();
            while (iter.hasNext()) {
                Long file = (Long)iter.next();
                long fileNum = file;
                FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
                summary = this.addTrackedSummary(summary, fileNum);
                map.put(file, summary);
            }
            TrackedFileSummary[] trackedFiles = this.tracker.getTrackedFiles();
            for (int i = 0; i < trackedFiles.length; ++i) {
                TrackedFileSummary summary = trackedFiles[i];
                long fileNum = summary.getFileNumber();
                Long file = new Long(fileNum);
                if (map.containsKey(file)) continue;
                map.put(file, summary);
            }
            return map;
        }
        return new TreeMap(this.fileSummaryMap);
    }

    public synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * 88;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateMiscMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap();
        this.cachePopulated = false;
    }

    synchronized void removeFile(Long fileNum) throws DatabaseException {
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        if (this.fileSummaryMap.remove(fileNum) != null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateMiscMemoryUsage(-88L);
        }
        this.deleteFileSummary(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileSummary(Long fileNum) throws DatabaseException {
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(false);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            long fileNumVal = fileNum;
            if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.WRITE)) {
                return;
            }
            OperationStatus status = OperationStatus.SUCCESS;
            while (status == OperationStatus.SUCCESS) {
                FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                if (ln != null) {
                    if (fileNumVal != ln.getFileNumber(keyEntry.getData())) {
                        break;
                    }
                    TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNumVal);
                    if (tfs != null) {
                        ln.setTrackedSummary(tfs);
                    }
                    cursor.delete();
                }
                status = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, true, false);
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    public void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw new DatabaseException("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.populateCache()) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = new Long(fileNum);
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            File file = new File(this.env.getFileManager().getFullFileName(fileNum, ".jdb"));
            if (!file.exists()) {
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(summary);
        ln.setTrackedSummary(tfs);
        this.insertFileSummary(ln, fileNum, sequence);
        summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNumLong, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateMiscMemoryUsage(88L);
        }
        return ln.getObsoleteOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrackedFileSummary getObsoleteDetail(Long fileNum, PackedOffsets packedOffsets) throws DatabaseException {
        PackedOffsets offsets;
        if (!this.tracker.getTrackDetail()) {
            return null;
        }
        boolean opened = this.populateCache();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        long fileNumVal = fileNum;
        ArrayList<long[]> list = new ArrayList<long[]>();
        TrackedFileSummary tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            OperationStatus status = OperationStatus.SUCCESS;
            if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                status = OperationStatus.NOTFOUND;
            }
            while (status == OperationStatus.SUCCESS) {
                FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                if (ln != null) {
                    if (fileNumVal != ln.getFileNumber(keyEntry.getData())) {
                        break;
                    }
                    PackedOffsets offsets2 = ln.getObsoleteOffsets();
                    if (offsets2 != null) {
                        list.add(offsets2.toArray());
                    }
                    cursor.evict();
                }
                status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
        if (!tfs.isEmpty() && (offsets = this.putFileSummary(tfs)) != null) {
            list.add(offsets.toArray());
        }
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            size += a.length;
        }
        long[] offsets3 = new long[size];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            System.arraycopy(a, 0, offsets3, index, a.length);
            index += a.length;
        }
        if (!$assertionsDisabled && index != offsets3.length) {
            throw new AssertionError();
        }
        packedOffsets.pack(offsets3);
        return tfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean populateCache() throws DatabaseException {
        if (this.cachePopulated) {
            return true;
        }
        if (!this.openFileSummaryDatabase()) {
            return false;
        }
        int oldMemorySize = this.fileSummaryMap.size() * 88;
        Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(false);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            if (cursor.positionFirstOrLast(true, null)) {
                OperationStatus status = cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, LockType.NONE, true);
                if (status != OperationStatus.SUCCESS) {
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                }
                while (status == OperationStatus.SUCCESS) {
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln == null) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                        continue;
                    }
                    byte[] keyBytes = keyEntry.getData();
                    boolean isOldVersion = ln.hasStringKey(keyBytes);
                    long fileNum = ln.getFileNumber(keyBytes);
                    Long fileNumLong = new Long(fileNum);
                    if (Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                        this.fileSummaryMap.put(fileNumLong, ln.getBaseSummary());
                        if (isOldVersion) {
                            this.insertFileSummary(ln, fileNum, 0);
                            cursor.latchBIN();
                            cursor.delete();
                            cursor.releaseBIN();
                        } else {
                            cursor.evict();
                        }
                    } else {
                        this.fileSummaryMap.remove(fileNumLong);
                        if (isOldVersion) {
                            cursor.latchBIN();
                            cursor.delete();
                            cursor.releaseBIN();
                        } else {
                            this.deleteFileSummary(fileNumLong);
                        }
                    }
                    if (isOldVersion) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                        continue;
                    }
                    if (this.getFirstFSLN(cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                    status = OperationStatus.NOTFOUND;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
            int newMemorySize = this.fileSummaryMap.size() * 88;
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateMiscMemoryUsage(newMemorySize - oldMemorySize);
        }
        this.cachePopulated = true;
        return true;
    }

    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        boolean exactKeyMatch;
        byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
        keyEntry.setData(keyBytes);
        int result = cursor.searchAndPosition(keyEntry, dataEntry, CursorImpl.SearchMode.SET_RANGE, lockType);
        if ((result & 1) == 0) {
            return false;
        }
        boolean bl = exactKeyMatch = (result & 2) != 0;
        if (exactKeyMatch && cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, lockType, true) != OperationStatus.KEYEMPTY) {
            return true;
        }
        OperationStatus status = cursor.getNext(keyEntry, dataEntry, lockType, true, !exactKeyMatch);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean openFileSummaryDatabase() throws DatabaseException {
        if (this.fileSummaryDb != null) {
            return true;
        }
        DbTree dbTree = this.env.getDbMapTree();
        Locker autoTxn = null;
        boolean operationOk = false;
        try {
            autoTxn = new AutoTxn(this.env, new TransactionConfig());
            DatabaseImpl db = dbTree.getDb(autoTxn, "_jeUtilization", null, false);
            if (db == null) {
                if (this.env.isReadOnly()) {
                    boolean bl = false;
                    return bl;
                }
                db = dbTree.createDb(autoTxn, "_jeUtilization", new DatabaseConfig(), null, false);
            }
            this.fileSummaryDb = db;
            operationOk = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (autoTxn != null) {
                autoTxn.operationEnd(operationOk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(false);
            OperationStatus status = cursor.putLN(keyBytes, ln, false);
            if (status == OperationStatus.KEYEXIST) {
                this.env.getLogger().log(Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
            }
            cursor.evict();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFileSummaryDatabase() throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        this.openFileSummaryDatabase();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        boolean ok = true;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            if (cursor.positionFirstOrLast(true, null)) {
                OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, LockType.NONE, true);
                while (status == OperationStatus.SUCCESS) {
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln == null) continue;
                    long fileNumVal = ln.getFileNumber(key.getData());
                    PackedOffsets offsets = ln.getObsoleteOffsets();
                    if (offsets != null) {
                        long[] vals = offsets.toArray();
                        for (int i = 0; i < vals.length; ++i) {
                            long lsn = DbLsn.makeLsn(fileNumVal, vals[i]);
                            if (this.verifyLsnIsObsolete(lsn)) continue;
                            ok = false;
                        }
                    }
                    cursor.evict();
                    status = cursor.getNext(key, data, LockType.NONE, true, false);
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        LogEntry o = this.env.getLogManager().getLogEntry(lsn);
        if (!(o instanceof LNLogEntry)) {
            return true;
        }
        LNLogEntry entry = (LNLogEntry)o;
        if (entry.getLN().isDeleted()) {
            return true;
        }
        DatabaseId dbId = entry.getDbId();
        DatabaseImpl db = this.env.getDbMapTree().getDb(dbId);
        if (db == null || db.getIsDeleted()) {
            return true;
        }
        IN bin = null;
        try {
            Tree tree = db.getTree();
            TreeLocation location = new TreeLocation();
            boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), entry.getDupKey(), entry.getLN(), false, true, false, false);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                boolean bl = true;
                return bl;
            }
            if (bin.isEntryKnownDeleted(index)) {
                boolean bl = true;
                return bl;
            }
            if (bin.getLsn(index) != lsn) {
                boolean bl = true;
                return bl;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (bin != null) {
                bin.releaseLatch();
            }
        }
    }

    static {
        $assertionsDisabled = !UtilizationProfile.class.desiredAssertionStatus();
    }
}

