/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import java.util.Iterator;

public class MemoryBudget
implements EnvConfigObserver {
    public static final int LONG_OVERHEAD = 16;
    public static final int BYTE_ARRAY_OVERHEAD = 16;
    public static final int OBJECT_OVERHEAD = 8;
    public static final int ARRAY_ITEM_OVERHEAD = 4;
    public static final int HASHMAP_OVERHEAD = 120;
    public static final int HASHMAP_ENTRY_OVERHEAD = 24;
    public static final int HASHSET_OVERHEAD = 130;
    public static final int HASHSET_ENTRY_OVERHEAD = 24;
    public static final int TWOHASHMAPS_OVERHEAD = 240;
    public static final int LN_OVERHEAD = 24;
    public static final int DUPCOUNTLN_OVERHEAD = 40;
    public static final int BIN_FIXED_OVERHEAD = 464;
    public static final int DIN_FIXED_OVERHEAD = 376;
    public static final int DBIN_FIXED_OVERHEAD = 480;
    public static final int IN_FIXED_OVERHEAD = 280;
    public static final int KEY_OVERHEAD = 16;
    public static final int LSN_SIZE = 8;
    public static final int LSN_ARRAY_BYTE_BASED_FIXED_OVERHEAD = 24;
    public static final int LSN_ARRAY_LONG_BASED_FIXED_OVERHEAD = 16;
    public static final int LOCK_OVERHEAD = 32;
    public static final int LOCKINFO_OVERHEAD = 16;
    public static final int TXN_OVERHEAD = 175;
    public static final int CHECKPOINT_REFERENCE_SIZE = 56;
    public static final int UTILIZATION_PROFILE_ENTRY = 88;
    public static final int TFS_LIST_INITIAL_OVERHEAD = 464;
    public static final int TFS_LIST_SEGMENT_OVERHEAD = 440;
    public static final int LONG_LIST_PER_ITEM_OVERHEAD = 25;
    public static final long MIN_MAX_MEMORY_SIZE = 98304L;
    public static final String MIN_MAX_MEMORY_SIZE_STRING;
    private static final long N_64MB = 0x4000000L;
    private long treeMemoryUsage;
    private long miscMemoryUsage;
    private Object memoryUsageSynchronizer = new Object();
    private long lockMemoryUsage;
    private long txnMemoryUsage;
    private long maxMemory;
    private long criticalThreshold;
    private long logBufferBudget;
    private long trackerBudget;
    private long cacheBudget;
    private long inOverhead;
    private long binOverhead;
    private long dinOverhead;
    private long dbinOverhead;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemoryBudget(EnvironmentImpl envImpl, DbConfigManager configManager) throws DatabaseException {
        this.envImpl = envImpl;
        envImpl.addConfigObserver(this);
        this.reset(configManager);
        this.inOverhead = IN.computeOverhead(configManager);
        this.binOverhead = BIN.computeOverhead(configManager);
        this.dinOverhead = DIN.computeOverhead(configManager);
        this.dbinOverhead = DBIN.computeOverhead(configManager);
    }

    public void envConfigUpdate(DbConfigManager configManager) throws DatabaseException {
        long oldLogBufferBudget = this.logBufferBudget;
        this.reset(configManager);
        if (oldLogBufferBudget != this.logBufferBudget) {
            this.envImpl.getLogManager().resetPool(configManager);
        }
    }

    private void reset(DbConfigManager configManager) throws DatabaseException {
        long newLogBufferBudget;
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (newMaxMemory != 0L) {
            if (jvmMemory < newMaxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + newMaxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
            if (newMaxMemory < 98304L) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " is " + newMaxMemory + " which is less than the minimum: " + 98304L);
            }
        } else {
            if (jvmMemory == Long.MAX_VALUE) {
                jvmMemory = 0x4000000L;
            }
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            newMaxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        if ((newLogBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE)) == 0L) {
            newLogBufferBudget = newMaxMemory >> 4;
        } else if (newLogBufferBudget > newMaxMemory / 2L) {
            newLogBufferBudget = newMaxMemory / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = newLogBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        } else if (startingBufferSize < 2048L) {
            startingBufferSize = 2048L;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        }
        long newCriticalThreshold = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE) / 100L;
        long newTrackerBudget = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE) / 100L;
        this.maxMemory = newMaxMemory;
        this.criticalThreshold = newCriticalThreshold;
        this.logBufferBudget = newLogBufferBudget;
        this.trackerBudget = newTrackerBudget;
        this.cacheBudget = newMaxMemory - newLogBufferBudget;
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        return Runtime.getRuntime().maxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCacheMemoryUsage() throws DatabaseException {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage = this.calcTreeCacheUsage();
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calcTreeCacheUsage() throws DatabaseException {
        long totalSize = 0L;
        INList inList = this.envImpl.getInMemoryINs();
        inList.latchMajor();
        try {
            Iterator iter = inList.iterator();
            while (iter.hasNext()) {
                IN in = (IN)iter.next();
                long size = in.getInMemorySize();
                totalSize += size;
            }
        }
        finally {
            inList.releaseMajorLatch();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTreeMemoryUsage(long increment) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage += increment;
        }
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMiscMemoryUsage(long increment) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.miscMemoryUsage += increment;
        }
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public void updateLockMemoryUsage(long increment) {
        this.lockMemoryUsage += increment;
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public void updateTxnMemoryUsage(long increment) {
        this.txnMemoryUsage += increment;
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public long accumulateNewUsage(IN in, long newSize) {
        return in.getInMemorySize() + newSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTreeMemoryUsage(long newSize) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage = newSize;
        }
    }

    public long getCacheMemoryUsage() {
        return this.treeMemoryUsage + this.miscMemoryUsage + this.lockMemoryUsage + this.txnMemoryUsage;
    }

    public long getTreeMemoryUsage() {
        return this.treeMemoryUsage;
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getTrackerBudget() {
        return this.trackerBudget;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public long getCacheBudget() {
        return this.cacheBudget;
    }

    public long getINOverhead() {
        return this.inOverhead;
    }

    public long getBINOverhead() {
        return this.binOverhead;
    }

    public long getDINOverhead() {
        return this.dinOverhead;
    }

    public long getDBINOverhead() {
        return this.dbinOverhead;
    }

    public static int byteArraySize(int arrayLen) {
        int size = 16;
        if (arrayLen > 4) {
            size += (arrayLen - 4 + 7) / 8 * 8;
        }
        return size;
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) {
        stats.setCacheDataBytes(this.getCacheMemoryUsage());
    }

    static {
        $assertionsDisabled = !MemoryBudget.class.desiredAssertionStatus();
        MIN_MAX_MEMORY_SIZE_STRING = Long.toString(98304L);
    }
}

