/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class SerialInput
extends ObjectInputStream {
    private ClassCatalog classCatalog;

    public SerialInput(InputStream inputStream, ClassCatalog classCatalog) throws IOException {
        super(inputStream);
        this.classCatalog = classCatalog;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        try {
            byte by = this.readByte();
            byte[] byArray = new byte[by];
            this.readFully(byArray);
            return this.classCatalog.getClassFormat(byArray);
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeExceptionWrapper(databaseException);
        }
    }
}

