/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList
extends StoredCollection
implements List {
    private static final EntryBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(Database database, EntryBinding entryBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, bl, null));
    }

    public StoredList(Database database, EntityBinding entityBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, bl, null));
    }

    public StoredList(Database database, EntryBinding entryBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, true, primaryKeyAssigner));
    }

    public StoredList(Database database, EntityBinding entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, true, primaryKeyAssigner));
    }

    private StoredList(DataView dataView, int n) {
        super(dataView);
        this.baseIndex = n;
        this.isSubList = true;
    }

    public void add(int n, Object object) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(new Long(n), null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.putBefore(object);
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                this.view.append(object, null, null);
            }
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean add(Object object) {
        this.checkIterAddAllowed();
        boolean bl = this.beginAutoCommit();
        try {
            this.view.append(object, null, null);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public int append(Object object) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(object, objectArray, null);
            this.commitAutoCommit(bl);
            return ((Number)objectArray[0]).intValue();
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    public boolean addAll(int n, Collection collection) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(new Long(n), null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                while (iterator.hasNext()) {
                    dataCursor.putBefore(iterator.next());
                }
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                while (iterator.hasNext()) {
                    this.view.append(iterator.next(), null, null);
                }
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public Object get(int n) {
        return super.get(new Long(n));
    }

    public int indexOf(Object object) {
        return this.indexOf(object, true);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    private int indexOf(Object object, boolean bl) {
        int n;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.find(object, bl);
            n = operationStatus == OperationStatus.SUCCESS ? dataCursor.getCurrentRecordNumber() - this.baseIndex : -1;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return n;
    }

    int getIndexOffset() {
        return this.baseIndex;
    }

    public ListIterator listIterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public ListIterator listIterator(int n) {
        StoredIterator storedIterator = this.iterator(this.isWriteAllowed());
        if (storedIterator.moveToIndex(n)) {
            return storedIterator;
        }
        storedIterator.close();
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public Object remove(int n) {
        try {
            Object[] objectArray = new Object[1];
            this.removeKey(new Long(n), objectArray);
            return objectArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    public Object set(int n, Object object) {
        try {
            return this.put(new Long(n), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public List subList(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        try {
            int n3 = this.baseIndex + n;
            return new StoredList(this.view.subView(new Long(n), true, new Long(n2), false, new IndexKeyBinding(n3)), n3);
        }
        catch (KeyRangeException keyRangeException) {
            throw new IndexOutOfBoundsException(keyRangeException.getMessage());
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        ListIterator listIterator = null;
        ListIterator listIterator2 = null;
        try {
            listIterator = this.listIterator();
            listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                if (!listIterator2.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                if (listIterator.nextIndex() != listIterator2.nextIndex()) {
                    boolean bl = false;
                    return bl;
                }
                Object e = listIterator.next();
                Object e2 = listIterator2.next();
                if (e == null) {
                    if (e2 == null) continue;
                    boolean bl = false;
                    return bl;
                }
                if (e.equals(e2)) continue;
                boolean bl = false;
                return bl;
            }
            if (listIterator2.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            StoredIterator.close(listIterator);
            StoredIterator.close(listIterator2);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DatabaseException {
        return dataCursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int n) {
            this.baseIndex = n;
        }

        public Object entryToObject(DatabaseEntry databaseEntry) {
            return new Long(IndexKeyBinding.entryToRecordNumber(databaseEntry) - (long)this.baseIndex);
        }

        public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
            IndexKeyBinding.recordNumberToEntry(((Number)object).intValue() + this.baseIndex, databaseEntry);
        }
    }
}

