/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbUtil;

public class DatabaseEntry {
    protected byte[] data;
    protected int dlen = 0;
    protected int doff = 0;
    protected int flags = 0;
    protected int offset = 0;
    protected int size = 0;
    protected int ulen = 0;
    static final DatabaseEntry IGNORE = new DatabaseEntry();
    static final DatabaseEntry UNUSED;
    protected static final int INT32SZ = 4;

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] byArray) {
        this.data = byArray;
        if (byArray != null) {
            this.size = byArray.length;
        }
    }

    public DatabaseEntry(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    int getMultiFlag() {
        return 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public boolean getPartial() {
        return (this.flags & 8) != 0;
    }

    public void setPartialOffset(int n) {
        this.doff = n;
    }

    public void setPartialLength(int n) {
        this.dlen = n;
    }

    public void setPartial(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public void setPartial(int n, int n2, boolean bl) {
        this.setPartialOffset(n);
        this.setPartialLength(n2);
        this.setPartial(bl);
    }

    public int getRecordNumber() {
        return DbUtil.array2int(this.data, this.offset);
    }

    public void setRecordNumber(int n) {
        if (this.data == null || this.data.length < 4) {
            this.data = new byte[4];
            this.size = 4;
            this.ulen = 0;
            this.offset = 0;
        }
        DbUtil.int2array(n, this.data, 0);
    }

    public boolean getReuseBuffer() {
        return 0 == (this.flags & 0x24);
    }

    public void setReuseBuffer(boolean bl) {
        if (bl) {
            this.flags &= 0xFFFFFFDB;
        } else {
            this.flags &= 0xFFFFFFDF;
            this.flags |= 4;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public boolean getUserBuffer() {
        return (this.flags & 0x20) != 0;
    }

    public int getUserBufferLength() {
        return this.ulen;
    }

    public void setUserBuffer(int n, boolean bl) {
        this.ulen = n;
        if (bl) {
            this.flags &= 0xFFFFFFFB;
            this.flags |= 0x20;
        } else {
            this.flags &= 0xFFFFFFDF;
        }
    }

    static {
        IGNORE.setUserBuffer(0, true);
        IGNORE.setPartial(0, 0, true);
        UNUSED = new DatabaseEntry();
    }
}

