/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2005
*      Sleepycat Software.  All rights reserved.
*
* $Id: LNInfo.java,v 1.1 2005/04/17 07:05:53 mark Exp $
*/

package com.sleepycat.je.cleaner;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.tree.LN;

/**
 * The information necessary to lookup an LN.  Used for pending LNs that are
 * locked and must be migrated later, or cannot be migrated immediately during
 * a split.
 */
final class LNInfo {

    private LN ln;
    private DatabaseId dbId;
    private byte[] key;
    private byte[] dupKey;

    LNInfo(LN ln, DatabaseId dbId, byte[] key, byte[] dupKey) {
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.dupKey = dupKey;
    }

    LN getLN() {
        return ln;
    }

    DatabaseId getDbId() {
        return dbId;
    }

    byte[] getKey() {
        return key;
    }

    byte[] getDupKey() {
        return dupKey;
    }
}
