/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2005
*      Sleepycat Software.  All rights reserved.
*
* $Id: TxnTestSuite.java,v 1.8 2005/01/28 17:43:07 mark Exp $
*/

package com.sleepycat.je.test;

import java.util.Enumeration;

import junit.framework.TestSuite;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.util.TestUtils;

/**
 * Runs a set of test cases for each type of transaction.
 * The test case class must extend TxnTestCase.
 */
public class TxnTestSuite extends TestSuite {

    /**
     * For running all three types of transactions: Null, Auto, User
     */
    public TxnTestSuite(Class testCaseClass, EnvironmentConfig envConfig) {

        this(testCaseClass, envConfig, null);
    }

    /**
     * For specifying the desirged txn types.  If txnTypes is null,
     * all three types are run.
     */
    public TxnTestSuite(Class testCaseClass,
                        EnvironmentConfig envConfig,
                        String[] txnTypes) {
        if (txnTypes == null) {
            txnTypes = new String[] { TxnTestCase.TXN_NULL,
                                      TxnTestCase.TXN_USER,
                                      TxnTestCase.TXN_AUTO };
        }
        if (envConfig == null) {
            envConfig = TestUtils.initEnvConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTxnNoSync(Boolean.getBoolean(TestUtils.NO_SYNC));
        }
        for (int i = 0; i < txnTypes.length; i += 1) {
            TestSuite suite = new TestSuite(testCaseClass);
            Enumeration e = suite.tests();
            while (e.hasMoreElements()) {
                TxnTestCase test = (TxnTestCase) e.nextElement();
                test.txnInit(envConfig, txnTypes[i]);
                addTest(test);
            }
        }
    }
}
