Summary: Utilities for working with LUKS-protected filesystems
Name: luks-tools
Version: 0.0.12
Release: 1
License: GPL
Group: Applications/System
Source: http://www.flyn.org/projects/%name/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.flyn.org
Requires: python pygtk2 dbus-python
BuildRequires: glib2-devel e2fsprogs-devel cryptsetup-luks check-devel

%description
The luks-tools package contains various utilities for working with 
LUKS-protected filesystems. HAL uses these utilities to automatically 
mount encrypted volumes when they are attached to a system, provided 
the user can produce the correct passphrase. These utilities are 
written as separate programs to allow MAC systems like SELinux to 
have fine-grained control over them.

luks-format
    A utility that formats a filesystem to contain a LUKS encryption 
    header.

luks-is-encrypted
    A tool that can determine if a filesystem contains a LUKS 
    encryption header.

luks-setup
    A utility that sets up the dm-crypt device map for a partition.

gnome-luks-format
    A GNOME front-end for luks-format.



%prep


%setup


%build
PATH=/sbin:/usr/sbin:$PATH %configure 
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-, root, root)
%{_datadir}/luks-tools/
%{_bindir}/*
%{_sbindir}/*
%{_mandir}/man*/*
%{_sysconfdir}/pam.d/*
%{_sysconfdir}/security/console.apps/*


%doc	AUTHORS COPYING ChangeLog INSTALL NEWS README FAQ


%changelog
* Sat Jan 20 2007 W. Michael Petullo <mike[@]flyn.org> - 0.0.12-1
   - Updated to luks-tools 0.0.12.

   - Add new files to package.

* Thu Jun 08 2006 W. Michael Petullo <mike[@]flyn.org> - 0.0.9-1
   - Updated to luks-tools 0.0.9.

   - BuildRequires check-devel.

   - Set path for configure.

* Thu Feb 16 2006 W. Michael Petullo <mike[@]flyn.org> - 0.0.8-2
   - BuildRequires cryptsetup-luks.

* Sun Feb 11 2006 W. Michael Petullo <mike[@]flyn.org> - 0.0.8-1
   - Updated to luks-tools 0.0.8.

* Wed Jul 20 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.7-1
   - Updated to luks-tools 0.0.7.

* Wed Jul 20 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.6-1
   - Updated to luks-tools 0.0.6.

* Wed Jul 13 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.5-1
   - Updated to luks-tools 0.0.5.

* Sun Apr 03 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.4-0.fdr.1
   - Updated to luks-tools 0.0.4.

* Wed Mar 30 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.3-0.fdr.1
   - Updated to luks-tools 0.0.3.

* Sun Mar 13 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.2-0.fdr.1
   - Updated to luks-tools 0.0.2.

* Sat Mar 12 2005 W. Michael Petullo <mike[@]flyn.org> - 0.0.1-0.fdr.1
   - Initial package.




