#include <stdlib.h>
#include <check.h>
#include <string.h>

#include "common.h"

START_TEST(test_strip_cr)
{
	char str[5];
	strcpy(str, "foo\n");
	fail_unless(strcmp(strip_cr(str), "foo") == 0,
		    "strip_cr test failed");
}
END_TEST

static Suite *common_suite(void)
{
	Suite *s = suite_create("common");

	TCase *tc_strip_cr = tcase_create("test_strip_cr");

	tcase_add_test(tc_strip_cr, test_strip_cr);

	suite_add_tcase(s, tc_strip_cr);

	return s;
}

int main(void)
{
	int nf;
	Suite *s = common_suite();
	SRunner *sr = srunner_create(s);
	srunner_run_all(sr, CK_NORMAL);
	nf = srunner_ntests_failed(sr);
	srunner_free(sr);
	return (nf == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
