
#define _GNU_SOURCE

#include <assert.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

#include "common.h"

static int verbose = 0;
static char *device = NULL;

static void print_usage(const int exitcode, const char *error,
			const char *more)
{
	if (error)
		assert(more);

	fprintf(stderr, "luks-is-encrypted [options] device\n\n"
		"-h, --help\n"
		"       print a list of options\n\n"
		"-v, --verbose\n" "     verbose display of messages\n\n");

	if (error)
		fprintf(stderr, "%s: %s\n", error, more);

	exit(exitcode);
}

int main(int argc, char *argv[])
{
	int c, opt_index = 0, status = EXIT_SUCCESS;
	struct option opts[] = {
		{"help", 0, 0, 'h'},
		{"verbose", 0, 0, 'v'},
		{0, 0, 0, 0}
	};

	while ((c = getopt_long(argc, argv, "hv", opts, &opt_index)) >= 0) {
		switch (c) {
		case 'h':
			print_usage(EXIT_SUCCESS, NULL, NULL);
		case 'v':
			verbose = 1;
			break;
		default:
			print_usage(EXIT_FAILURE, NULL, NULL);
		}
	}

	if (argv[optind] == NULL)
		print_usage(EXIT_FAILURE, NULL, NULL);
	device = argv[optind];

	msg(verbose, "checking if %s is encrypted\n", device);
	if (run_cryptsetup_isLuks(device) == 0) {
			status = EXIT_FAILURE;
			goto _exit;
	}

      _exit:
	if (status == EXIT_SUCCESS)
		fprintf(stdout, "Device %s seems to be encrypted\n",
			device);
	else
		fprintf(stdout, "Device %s does not seem to be encrypted\n",
			device);
	exit(status);
}
