
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <assert.h>
#include <limits.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include "common.h"

static int verbose = 0;
static char *device = NULL;

static void print_usage(const int exitcode, const char *error,
			const char *more)
{
	if (error)
		assert(more);

	fprintf(stderr, "luks-setup [options] device\n\n"
		"-h, --help\n"
		"	print a list of options\n\n"
		"-v, --verbose\n" "	verbose display of messages\n\n");
	if (error)
		fprintf(stderr, "%s: %s\n", error, more);

	exit(exitcode);
}

int main(int argc, char *argv[])
{
	int c, opt_index = 0, status = EXIT_SUCCESS;
	char passphrase[BUFSIZ + 1], uuid[UUIDLEN + 1];
	struct option opts[] = {
		{"help", 0, 0, 'h'},
		{"verbose", 0, 0, 'v'},
		{0, 0, 0, 0}
	};

	while ((c = getopt_long(argc, argv, "hv", opts, &opt_index)) >= 0) {
		switch (c) {
		case 'h':
			print_usage(EXIT_SUCCESS, NULL, NULL);
		case 'v':
			verbose = 1;
			break;
		default:
			print_usage(EXIT_FAILURE, NULL, NULL);
		}
	}

	if (argv[optind] == NULL)
		print_usage(EXIT_FAILURE, NULL, NULL);
	device = argv[optind];

	if (run_cryptsetup_isLuks(device) == 0) {
		fprintf(stderr, "%s does not seem to be encrypted\n", device);
		status = EXIT_FAILURE;
		goto _exit;
	}

	if (read_key(passphrase, BUFSIZ) == 0) {
		fprintf(stderr, "Could not read key\n");
		status = EXIT_FAILURE;
		goto _exit;
	}

	if (run_cryptsetup_luksUUID(device, uuid) == 0) {
		status = EXIT_FAILURE;
		goto _exit;
	}

	msg(verbose, "executing cryptsetup\n");
	if (run_cryptsetup_luksOpen
	    (DMCRYPT_PREFIX, uuid, device, passphrase) == 0) {
		status = EXIT_FAILURE;
		goto _exit;
	}

      _exit:
	exit(status);
}
