/*****************************************************************************
 * $Id: str_heap.c,v 1.2 2003/01/16 03:07:32 jimb Exp $
 * Author		: Jim Brooks <devel@jimbrooks.org>
 * Description	: Functions for a simple heap of strings.
 *                The only supported operation is appending strings to a heap.
 *****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <strings.h>

#include "str_heap.h"

inline void
StrHeapCreate( STR_HEAP* pStrHeap, int size )
{
   pStrHeap->pBase = (char*) malloc( size );
   pStrHeap->size  = size;
   pStrHeap->pFree = pStrHeap->pBase;
}

inline void
StrHeapDelete( STR_HEAP* pStrHeap )
{
   free( pStrHeap->pBase );

   pStrHeap->pBase = NULL;
   pStrHeap->size = 0;
   pStrHeap->pFree = NULL;
}

inline char*
StrHeapAppendFast( STR_HEAP* pStrHeap, char* str, int strLen )
{
  /*
   * Append string into heap.
   */
   memcpy( pStrHeap->pFree, str, strLen + 1 );	/* plus one for null char */
   pStrHeap->pFree += strLen + 1;

  /*
   * Return pointer to string.
   */   
   return pStrHeap->pFree - strLen - 1;
}

inline char*
StrHeapAppend( STR_HEAP* pStrHeap, char* str, int strLen )
{
   int	used;

  /*
   * Enough room?
   */
   used = pStrHeap->pFree - pStrHeap->pBase;
   if ( (used + strLen + 1)  <=  pStrHeap->size )
      return StrHeapAppendFast( pStrHeap, str, strLen );
   else
      return NULL;
}
