/******************************************************************************
 * $Id: str_heap.h,v 1.2 2003/01/16 03:07:32 jimb Exp $
 * Author		: Jim Brooks <devel@jimbrooks.org>
 * Description	: String heap.
 ******************************************************************************/

#ifndef STR_HEAP_H
#define STR_HEAP_H

typedef struct
{
   char* 	pBase;
   int		size;
   char*	pFree;
} STR_HEAP;

inline void
StrHeapCreate( STR_HEAP* pStrHeap, int size );

inline void
StrHeapDelete( STR_HEAP* pStrHeap );

inline char*
StrHeapAppendFast( STR_HEAP* pStrHeap, char* str, int strLen );

inline char*
StrHeapAppend( STR_HEAP* pStrHeap, char* str, int strLen );

#endif /* STR_HEAP_H */
