/*****************************************************************************
 * $Id: dangling_else.c,v 1.5 2003/10/01 01:12:58 jimb Exp $
 * Author:		Jim Brooks <tools@jimbrooks.org>
 * Start Date:	2003/09/28
 * Description:	Tests for lwlint.
 * License:		GNU GENERAL PUBLIC LICENSE (GPL)
 * Notes:
 *****************************************************************************/

main()
{
	// ### DANGLING ELSE ###
	if ( a )
		if ( b ) return;
	else
		return;

	// ### DANGLING ELSE ###
	if ( a ) if ( b ) return;
	else
		return;

	// ok
	if ( a )
	{
		if ( b ) return;
	}
	else
		return;

	// ok
	if ( a ) return;

	// ### DANGLING ELSE ###
	if ( a ) if ( b ) return;
	else
		return;

	// --- suppressed ---
	if ( a )
		if ( b ) return;
	else // @lint
		return;

	{ }

	if ( a ) if ( b ) return;
	else /*@lint*/
		return;
}

hack()
{
	// ok (a snippet from linux kernel)
	if (!error) {
		if (old_dir == new_dir)
			inode_dir_notify(old_dir, DN_RENAME);
		else {
			inode_dir_notify(old_dir, DN_DELETE);
			inode_dir_notify(new_dir, DN_CREATE);
		}
	}

	// WRONG (I screwed this up on purpose.  Note indentation isn't misleading.)
	// Should be reported by a weak warning since indentation seems OK.
	if (!error)
		if (old_dir == new_dir)
			inode_dir_notify(old_dir, DN_RENAME);
		else 
			inode_dir_notify(old_dir, DN_DELETE);
			inode_dir_notify(new_dir, DN_CREATE);

	// ok (I modified this)
	if (!error)
	{
		if (old_dir == new_dir)
			inode_dir_notify(old_dir, DN_RENAME);
		else 
			inode_dir_notify(old_dir, DN_DELETE);
			inode_dir_notify(new_dir, DN_CREATE);
	}
}
