Codage des accents: La traduction francaise utilise le codage UTF-8
(dit aussi Unicode). Si ce n'est pas le codage standard de votre version
de Linux, modifiez cette option pour le terminal dans lequel vous lancez
lxdvdrip.


Aide sur lxdvdrip
=================

Veuillez utiliser ce porogramme dans le respect des droits d'auteurs.
Si la copie d'un DVD Video est autorisée à titre de sauvegarde et pour un usage privé,
ceci n'autorise pas à circonvenir les dispositifs de protection contre la copie.

Pour plus de détails sur la loi applicable en Allemagne, consultez:
    http://transpatent.com/gesetze/urhg.html 


Responsabilité:
===============

L'utilisation de lxdvdrip se fait à vos risques. L'auteur ne garantit pas le bon fonctionnement de lxdvdrip, et n'est pas responsable d'éventuels dommages qui résulteraient de son utilisation.


Fichiers dans cette Archive
===========================

- Makefile:      pour compiler lxdvdrip
- lxdvdrip.c:    le programme principal
- README.de:     ce texte d'aide en allemand
- README.en:     ce texte d'aide en anglais
- README.fr:     ce texte d'aide en français
- lxdvdrip.conf: exemple de fichier de configuration
- Changelog.de:  évolution de version en version / en allemand
- Changelog.en:  évolution de version en version / en anglais
- Changelog.fr:  évolution de version en version / en français
- COPYING:       le texte de la licence GPL
- dvdauthor/dvdvob.c: 
                 Patch pour dvdauthor-0.6.10
- vamps:         version complète de vamps (nécessaire pour le mode Copie)
- mpgtx/mpgtx:   Binaire statique de mpgtx
- mpgtx/mpeg.cxx:Patch pour le fichier source


Installation
============ 

- décompactage de l'archive: 

tar zxvf lxdvdrip.tgz 

- compilation et installation: 

cd lxdvdrip 
make 
make install 

La commande "make install" copie le programme "lxdvdrip" dans "/usr/local/bin".

Vous devez alors éditer le fichier de configuration "lxdvdrip.conf.FR". 
Après avoir effectué et sauvegardé vos modifications, copiez ce fichier dans "/etc" par:

code: cp lxdvdrip.conf.FR /etc/lxdvdrip.conf.

(code: cp lxdvdrip.FR.conf ~/.lxdvdrip.conf)

Voir plus bas les commentaires sur les options du fichier de configuration.


Patch pour dvdauthor:
======================

Dans le sous-répertoire "dvdauthor" se trouve le fichier "dvdvob.c"
Il s'agit là d'un patch pour corriger l'erreur "ERR: SCR moves backwards"
et de la correction d'une bogue de navigation qui empêche certains 
players de rembobiner le film.

Installation:
- télécharger dvdauthor 0.6.10 en format source
  (http://sourceforge.net/project/showfiles.php?group_id=59028)
- décomprimer les fichiers (tar zxvf dvdauthor*)
- copier "dvdvob.c" dans le répertoire source en remplacement du fichier d'origine
- compiler puis installer (./configure, make, make install)


Patch pour vamps:
==================

Vamps n'est utilisé que dans le mode Copie pour une sauvegarde complète des
DVD contenant plus de 4,7 Go.

Dans le sous-répertoire "vamps" se trouve une version complète de vamps.
Il n'est donc plus nécessaire de la télécharger depuis www.heise.de.
La version originale ne fonctionnant pas, celle-ci est modifiée pour 
accepter les flux de dvdunauthor et les erreurs de virgule flottante sont corrigées.

Installation par "make" et "make install".



Installation de mpgtx:
======================

"mpgtx" est utilisé dans le mode Copie partielle pour calculer la durée des titres
rippés. Vous pouvez utiliser le fichier binaire précompilé nommé "mpgtx" en le copiant
dans votre répertoire d'éxécutables p.ex."/usr/local/bin".
Si vous préférez le compiler depuis sa source, utilisez "mpeg.cxx" pour remplacer le
fichier d'origine du même nom dans les sources de mpgtx-version 1.3.



Prérequis:
========== 

Les programmes suivants doivent être installés par ailleurs:

* pour l'extraction:
- streamdvd >= 0.40 (http://www.badabum.de/streamdvd.html)
  et/ou
- mplayer >= 0.90 (http://www.mplayerhq.hu/)
  et/ou
- transcode >= 0.6.12 (http://www.theorie.physik.uni-goettingen.de/~ostreich/transcode/)

* pour utiliser le mode "Transcode parallèle":
- buffer (http://rpmfind.net/linux/RPM/contrib/libc6/i386/buffer-1.19-1.i386.html) ou
- mbuffer (http://www.rcs.ei.tum.de/~maierkom/privat/software/mbuffer/) ou
- bfr (http://www.glines.org:8000/software/buffer.html)
  (lxdvdrip.conf, Parameter "buffer_name=...")

  ou
- dvdbackup (http://dvd-create.sourceforge.net/)
- vamps (http://www.heise.de/ct/ftp/04/01/094/)

Remarque: Si vous avez des problèmes en utilisant streamdvd, veuillez utiliser mplayer ou
transcode. Ce n'est pas aussi rapide, mais fonctionne parfaitement.

* pour la création de la structure Video-DVD
- dvdauthor (http://dvdauthor.sourceforge.net/)

* pour la lecture du DVD
- libdvdread (http://www.dtek.chalmers.se/groups/dvd/)

* pour le calcul du facteur de réduction
- streamanalyze (sur la page web de streamdvd)

- Pour créer des DVD avec menu dvdwizard >= 0.4.2 est aussi nécessaire:
  http://www.wershofen.de/downloads/dvdwizard.tar.gz
  http://udrecsuite.sourceforge.net/doku_dvdwizard.html

Remarque: Les versions récentes de dvdauthor rencontrent des problèmes lors du traitement des flux mpeg provenant de streamdvd <= 0.3.
Vous pouvez alors utiliser une version plus ancienne <= 0.66 ou la version patchée.
Vous pouvez aussi utiliser la version 0.40 de streamdvd, qui ne crée plus de problème.

Les programmes suivants sont facultatifs:

* pour la prévisualisation
- un player tel que mplayer (http://www.mplayerhq.hu/)

* pour la gravure
- growisofs (fait partie des dvd+-rw-tools, http://fy.chalmers.se/~appro/linux/DVD+RW/)
et/ou
- cdrecord-prodvd (http://gd.tuwien.ac.at/utils/misc/schilling/cdrecord/ProDVD/)
  obligatoirement associé à 
  cdrtools (car il faut mkisofs)

* pour analyser le contenu du DVD d'origine
- lsdvd (http://acidrip.thirtythreeandathird.net/)

Dans tous les schémas d'utilisation, lxdvdrip vérifie au préalable que tous les programmes nécessaires sont présents.


Qu'est-ce que lxdvdrip ? 
======================== 

Ce programme est capable d'extraire un titre ou des chapitres d'un DVD, d'en réarranger les fichiers dans une structure de DVD, de prévisualiser le résultat et de le graver sur un DVD+/-R.
Le programme détermine quel est le titre le plus long, et calcule le facteur de réduction pour la requantification de la video.

L'option de commande "-st" permet de choisir le schéma qui sera utilisé.

Le schéma de base utilise le package streamdvd.
   => "-st=streamdvd"

Le schéma "traditionnel" en 4 étapes (Extraire & requantifier, Extraire l'audio, Mixer les deux flux, Créer une structure DVD) est également supporté.
Selon le programme à utiliser:
   => "-st=transcode" 
ou
   => "-st=mplayer"

Un troisième schéma, très rapide, est disponible: "Transcode parallèle". Dans ce cas, toutes les opérations passent par tuyaux, il n'y a donc qu'une seule et unique passe en lecture.
   => "-st=trans_par"

Un quatrième schéma d'extraction vérifie d'abord la taille du DVD. Si celle-ci est inférieure à 4,7Go, l'ensemble du DVD est copié sur le disque dur et on peut graver le DVD-R directement.
Mais si le DVD contient plus de 4,7Go, le programme utilisera alors "dvdunauthor" pour l'extraction, "tcprobe" pour sélectionner le contenu des fichiers VOB (énumération des pistes audio et sous-titres), "vamps" pour la requantification, et enfin "dvdauthor" pour la masterisation.
Ce schéma permet d'obtenir une structure DVD capable d'être gravée sur un support de 4,7Go, contenant les pistes video, audio et sous-titres et le découpage en chapitres de l'original, mais PAS les menus.
ATTENTION: Pour utiliser ce schéma, vous devrez patcher les programmes "dvdauthor" et "vamps". Les fichiers nécessaires sont inclus dans la présente archive. Il suffit de les copier sur les originaux et de recompiler ces deux programmes.
   => "-st=copy".

Nouveauté aussi, le mode "Copie partielle" (lxdvdrip -st=partcopy). Comme dans le mode Copie, le DVD complet est copié
sur le disque dur par dvdunauthor. L'utilisateur peut alors prévisualiser et sélectionner les titres à copier.
La requantification est assurée par vamps, tout comme dans le mode Copie. L'ensemvble des pistes audio et des 
sous-titres est copié. Ce mode est pratique pour les sauvegardes des DVD contenant par exemple des séries TV.

   => "-st=partcopy".


DVD avec Menu
=============

Avec l'intégration de dvdwizard votre DVD de sauvegarde obtient un Menu. 
Il s'agit d'un menu simple, avec des boutons pour lancer le film et
obtenir la liste des chapitres.  Vous devez installer dvdwizard (lien ci dessus) 
et 2 images pour le fond d'écran du menu.

=> README.dvdwizard.fr


Utilisation des programmes d'extraction par lxdvdrip
====================================================

Voici les appels effectués par lxdvdrip selon le schéma utilisé:

streamdvd (-st=streamdvd): 

- dvdauthor -t .... -f 'streamdvd ... |'

mplayer (-st=mplayer):

- mplayer dvd://1 -dumpstream -dumpfile /dev/stdout | tcextract -t vob -a 0 -x mpeg2 | tcrequant -f 2 > /tmp/ofile.m2v
- mplayer dvd://1 -alang de -dumpaudio -dumpfile /tmp/ofile.ac3
- tcmplex -i /tmp/ofile.m2v -p /tmp/ofile.ac3 -m d -o /tmp/film-neu.vob
- dvdauthor -t -a ac3+de -o film-dvd film-neu.vob

transcode (-st=transcode):

- tccat -i /dev/dvd -T1,-1 | tcextract -t vob -x mpeg2 | tcrequant -f 2 > /tmp/ofile.m2v
- tccat -i /dev/dvd -T1,-1 | tcextract -t vob -x ac3 -a0 > /tmp/ofile.ac3
- tcmplex -i /tmp/ofile.m2v -p /tmp/ofile.ac3 -m d -o /tmp/film-neu.vob
- dvdauthor -t -a ac3+de -o film-dvd film-neu.vob

transcode parallel (-st=trans_par):

- mkfifo foo.s1
- mkfifo foo.s2
- mkfifo foo.ac3
- mkfifo foo.m2v
- mkfifo foo.mpeg
- mkdir dvdimage
- mplex -f 8 -S 0 -o foo.mpeg foo.m2v foo.ac3 &
- buffer -s 64k -m 16m -i foo.s1 | tcextract -t vob -x mpeg2 | tcrequant -f 2.0 >foo.m2v &
- buffer -s 64k -m 16m -i foo.s2 | tcextract -t vob -x ac3 -a 0 >foo.ac3 &
- tccat -i /dev/dvd -T 1,-1 | tee foo.s1 foo.s2 >/dev/null &
- dvdauthor -t -a ac3+en -o dvdimage foo.mpeg

Copymode, DVD <= 4.7 GB (-st=copy):

- dvdbackup -i /dev/dvd -o /tmp/film-dvd -M

Copymode, DVD > 4.7 GB (-st=copy):

- dvdunauthor /dev/dvd
- tcprobe (Selection du contenu des VOBs: Video, Sous-titres, Audio)
- dvdauthor -t ... -f 'cat *.vob | vamps -E ...|'
- dvdauthor -T

mode "Copie partielle": voir mode Copie (-st=partcopy)


Fichier de configuration
========================

Le nom du fichier de configuration est /etc/lxdvdrip.conf / ~/.lxdvdrip.conf.
Il permet d'attribuer une valeur par défaut à chacune des options de la ligne de commande.

Il n'est alors nécessaire d'entrer en ligne de commande que les valeurs non-standard.

Par exemple si le facteur de réduction ne vous convient pas, remplacez la valeur ou la méthode de calcul par défaut en ajoutant à la ligne de commande "-f=valeur".

Exemple de configuration pour utiliser "growisofs" et "mplayer":

---------------------------------------------------------------------
titel=0
audio=1
untertitel=0
faktor=0
dvdleser=/dev/dvd
dvdbrenner=/dev/scd0
filmverzeichnis=/tmp/film-dvd
brennprogramm=1
vobplayer=mplayer
language=fr
audio-default=0
streamtool=streamdvd
wait-burn=1
tmp=/tmp
delete=1
mplex=tcmplex
chapter=1
free=1
---------------------------------------------------------------------

Exemple utilisant cette fois "cdrecord-prodvd" et "xine":

---------------------------------------------------------------------
titel=0
audio=1
untertitel=0
faktor=0
dvdleser=/dev/dvd
dvdbrenner=0,0,0
filmverzeichnis=/tmp/film-dvd
brennprogramm=2
vobplayer=xine
language=fr
audio-default=0
streamtool=transcode
wait-burn=1
tmp=/tmp
delete=1
mplex=mplex
chapter=1
free=1
speed=4
burnkey=CDR_SECURIRY=xyz
---------------------------------------------------------------------

La liste des options est disponible en tapant "lxdvdrip -h" (ou --help):

---------------------------------------------------------------------------------------------
Aide pour lxdvdrip
==================

Commande: lxdvdrip [-option=valeur]

Vous ne devez spécifier que les options qui diffèrent de la valeur par défaut spécifiée dans le fichier de configuration (/etc/lxdvdrip.conf, ~/.lxdvdrip.conf). Si aucune valeur n'est spécifiée, ni dans la ligne de commande ni dans le fichier de configuration, c'est la valeur donnée entre parenthèse qui est utilisée.

-st=extracteur       : streamdvd, mplayer, transcode, trans_par (Transcode parallèle), copy,
                       partcopy (-st=streamdvd)
-tmp=répertoire      : Répertoire temporaire pour l'extracteur mplayer (-tmp=/tmp)
-mp=mplex            : Multiplexeur, uniquement si -st=mplayer, utilisez mplex et non tcmplex qui pose parfois problème (-mp=tcmplex)
-t=titre             : Numéro du titre à extraire, "lsdvd" affiche tous les titres, 
                       0=pour choisir automatiquement le titre le plus long,
                       l=pour choisir titre dans la liste des titres du DVD (-t=0)
-hq=x                : Copie Haute Qualité, copie 1 DVD-9 => 2 DVD-5,
                       -hq=1=>1ère partie, -hq=2=>2ème partie (-hq=0)
-vf=x                : dvdauthor avec -v (Video Format) (0=non,1=avec) (-vf=0)
-a=langue audio      : "-a=1": allemand, "-a=2": anglais, "-a=3": allemand+anglais,
                       "-a=4,xy" pour la langue xy, p.ex. "-a=4,fr" pour le français, 
                       "-a=l" pour choisir dans la liste des langues du DVD (-a=1)
-ad=format audio     : 0=première piste dans la langue, 1=AC3 avec le plus de canaux, 
                       2=DTS si possible (pas avec mplayer) (-ad=0)
-lab=VolumeID        : Nom du DVD (Volume-ID/Label)
-chap=chapitrage     : 0=sans chapitrage, 1=avec chapitrage, lxdvdrip, 2=avec tcprobe (-chap=1)
-u=piste sous-titres : Numéro de la piste s/t (utiliser "lsdvd" pour infos), 
                       0=sans s/t, l=choix dans la liste, numéro, langue "-u=de" (-u=0)
-fv=répertoire       : répertoire d'extraction (-fv=/tmp/film-dvd)
-f=facteur           : Le facteur est calculé automatiquement, mais vous pouvez le forcer
                       en indiquant votre valeur, aussi "-f=-1" pour mesurer sur un test
                       d'un chapitre, ou "-f=-2" pour utiliser "streamanalyze" (-f=0)
-dl=lecteur DVD      : Nom du lecteur DVD (-dl=/dev/dvd)
-db=graveur DVD      : Nom du graveur (-db=/dev/scd0)
-bp=outil de gravure : 1=growisofs, 2=cdrecord-prodvd, 3=cdrecord-prodvd on the fly, 0=ne pas graver (-bp=1)
-sp=x                : Vitesse de gravure (-sp=0)
-wb=confirmer DVD-R  : Attente d'une confirmation avant de graver le DVD-R (1=oui, 0=non) (-wb=1)
-format=             : Formater le RW avant de graver 1=oui, 0=non
-vp=lecteur VOB      : Lecteur pour la prévisualisation VOB, off=pas de prévisualisation (-vp=mplayer)
-lang=fr             : Programme en fr:français, en:anglais, de:allemand (-lang=de)
-d=effacer           : Effacer les fichiers VOB après gravure (0=non, 1=oui) (-d=1)
-free=vérifier       : Vérifier l'espace disque libre avant l'extraction (0=non, 1=oui) (-free=1)
-file=fichier        : Sortie de dvdauthor+growisofs dans un fichier, p.ex."-file=/tmp/dvd.vob"
                       -file=0=>non fichier
-dw=x                : dvdwizard? 0=non, 1=oui (0)
-h                   : Afficher ce texte d'aide (aussi --help)
-v                   : Afficher la version (aussi --version)
Example: # lxdvdrip -t=1

Note sur l'option -ad: 
   S'il y a 2 pistes audio dans la même langue et que l'on a spécifié "-ad=2", on utilise par défaut la piste au format dts (meilleure qualité). 
   S'il y a 2 pistes au format AC3 et que l'on a spécifié "-ad=1", on utilise celle dont le nombre de canaux est le plus élevé
   La valeur par défaut est "-ad=0" qui utilise la première piste du langage voulu.
---------------------------------------------------------------------------------------------


Correspondance des options entre:
fichier de config       ligne de commande
==================================================
titel                       -t
audio                       -a
untertitel                  -u
faktor                      -f
dvdleser                    -dl
dvdbrenner                  -db
filmverzeichnis             -fv
brennprogramm               -bp
speed                       -sp
vobplayer                   -vp
language                    -lang
audio-default               -ad
streamtool                  -st
wait-burn                   -wb
format                      -format
tmp                         -tmp
delete                      -d
mplex                       -mp
chapter                     -chap
free                        -free
videoformat                 -fv
file                        -file
dvdwizard                   -dw


Remarques sur le lecteur DVD
============================

Il existe normalement un lien "/dev/dvd" sur le lecteur de DVD.
Si ce n'est pas le cas, vous pouvez le créer en étant "root" par:
 "ln -s /dev/hdc /dev/dvd".

En utilisant le schéma "streamdvd", vous pouvez réduire et graver une vidéo copiée par "dvdbackup" sur le disque dur en entrant la commande :

"lxdvdrip -dl=/chemin/vers/la/video" (le chemin remplace le nom du lecteur DVD).


Remarques sur le graveur DVD
============================

Si vous utilisez "growisofs" avec un graveur IDE en émulation SCSI, le nom du graveur est généralement "/dev/scd0".

Si par contre vous utilisez "cdrecord-prodvd", le nom du graveur est de la forme "0,0,0". Pour obtenir la valeur correcte, utilisez la commande "cdrecord-prodvd -scanbus".

"cdrecord-prodvd" fonctionne aussi avec les graveurs IDE sans l'émulation SCSI.
Dans ce cas, le nom du graveur est de la forme "ATAPI:0,0,0".


Remarques sur le calcul du facteur de requantification, Testrip
===============================================================

Si vous utilisez "streamdvd", "lxdvdrip" calcule la taille de la video et de tous les flux audio retenus. Ce résultat n'est pas optimal car le calcul de la taille des pistes audio utilise un taux de transfert (bit-rate) moyen.

Pour mieux approcher la réalité, on peut effectuer un test par (-f=-1). Dans ce cas, un chapitre échantillon vers le milieu du DVD est lu et la comparaison entre la taille calculée et la taille théorique sert de correction au facteur déterminé par calcul. Cette méthode donne un très bon résultat.

Vous pouvez aussi demander le calcul du facteur de requantification par "streamanalyze" en spécifiant (-f=-2).


Recherche d'erreurs / Fichier de log
====================================

Pour chercher l'origine d'une erreur, il est souvent utile de pouvoir
enregistrer dans un fichier les messages provenant de lxdvdrip ou des
outils qu'il appelle. Il faut alors appeler lxdvdrip avec la commande
suivante:

"lxdvdrip ... 2>&1 | tee lxdvdrip.log"

dans laquelle:

  "..." représente les éventuelles options lxdvdrip en ligne de commande,
  "2>&1" envoie les messages d'erreur (stderr) vers "/dev/stdout",
  "tee lxdvdrip.log" recopie la sortie console (stdout) dans le fichier "lxdvdrip.log".

De cette façon, l'intégralité des messages générés, aussi bien par
lxdvdrip que par les outils qu'il appelle, est disponible après
exécution dans le fichier de log "lxdvdrip.log".


