# Fichier de configuration pour lxdvdrip.
# Toutes les options de ce fichier sont modifiables par la ligne de commande.
# Les abréviations de la ligne de commande sont indiquées avant chaque option.
# Toutes les entrées sont de la forme "option=valeur" sans espaces.
 
# version du fichier de configuration
version=1.61

# Choix du titre à ripper (vérifiez avec "lsdvd").
# Entrer "titel=0" pour choisir automatiquement le titre le plus long.
# "titel=l": Choisir Titre dans List.
# Pour la ligne de commande: "-t=".
titel=0

# 'dvdauthor -v' (aspect ratio, x * y, pal/ntsc)
# 0=non, 1=avec. Pour la ligne de commande: "-vf=".
videoformat=1

# Choix de la piste audio.
# Note: la valeur l (liste) permet de choisir à la volée (liste des pistes puis choix)
# Pour la ligne de commande: "-a=".
audio=4,fr

# Choix de la piste de sous-titres (vérifiez avec "lsdvd").
# Note 1: la valeur "l" (liste) permet de choisir à la volée (liste des pistes puis choix).
# Note 2: vous pouvez aussi saisir le code de langue, par exemple "untertitel=fr".
# Note 3: Avec "f" tous les "Sous-titres forcés" seront inclus.
# Note 4: Avec "a" tous les Sous-titres seront inclus (Vamps).
# Pour la ligne de commande: "-u=".
untertitel=0

# Facteur de réduction.
#  "0": Le facteur de réduction sera calculé automatiquement.
#   >0: La valeur spécifiée sera utilisée. 
# "-1": Le facteur sera calculé par test d'un chapitre avec "transcode".
# Pour la ligne de commande: "-f=".
faktor=0

# Taille du DVD en octets.
# La capacité brute est de 4700000000 octets. Comme l'estimation
# ne donne jamais la taille finale à 100 %, il faut garder une réserve.
# Si l'outil d'extraction est très précis vous pouvez vous approcher
# de la capacité brute.
groesse_dvd=4600000000

# Lecteur de DVD.
# Pour la ligne de commande: "-dl=".
dvdleser=/dev/dvd

# Graveur de DVD.
# Pour growisofs, normalement de la forme "/dev/scd0".
# Pour cdrecord-prodvd, normalement de la forme "0,0,0" (voir "cdrecord-prodvd -scanbus").
# Pour la ligne de commande: "-db=".
dvdbrenner=/dev/scd0

# Répertoire pour les fichiers VOB (utilisé par "dvdauthor -t ...").
# Pour la ligne de commande: "-fv=".
filmverzeichnis=/tmp/film-dvd

# Construire un fichier VOB au lieu d'une structure DVD,
# p.ex. comme point de départ pour l'outil "dvdwizard". 
# "0": Option inactive.
# "1": Option active, le fichier sera dans le répertoire
# temporaire avec comme nom le label du DVD p.ex. "/tmp/film.vob"
# Depuis la ligne de commande: "-file=".
file=0

# Programme à utiliser pour la gravure.
# "1": growisofs
# "2": cdrecord-prodvd
# "3": cdrecord-prodvd à la volée
# "4": mkisofs (ISO-Image) "/tmp/dvdrip.img"
# "5": mkisofs (ISO-Image) "Volume-ID.img"
# "0": gravure=non
# Pour la ligne de commande: "-bp=".
brennprogramm=1

# Programme de prévisualisation des VOB après extraction.
# Entrez le nom réel du programme, ou "off" pour supprimer la prévisualisation.
# Pour la ligne de commande: "-mp=".
vobplayer=mplayer

# Paramètre à passer au programme de prévisu.
# Ce paramètre doit être placé entre guillemets "xxx".
# p.ex. pour spécifier le périphérique de sortie à mplayer.
vobplay_param=""

# Langue d'interface.
# "en"=English, "de"=german, "fr"=french
# Pour la ligne de commande: "-lang=".
language=fr

# Format audio préféré.
# "0"=ac3 2 Canaux
# "1"=ac3 5.1
# "2"=dts.
# Pour la ligne de commande: "-ad=".
audio-default=1

# Programme d'extraction.
# Les valeurs possibles sont: 
#     vamps
#     vamps_menu (=Vamps avec menu)
#     mplayer
#     transcode
#     trans_par (Transcode parallel)
#     copy
#     partcopy
# Pour la ligne de commande: "-st=".
streamtool=vamps

# Message d'attente pour l'insertion du DVD-R.
# "0"=Pas de message
# "1"=Question et pause.
# Pour la ligne de commande: "-wb=".
wait-burn=1

# Multi Copies?
# "1": Après chaque DVDR le programme demande le suivant.
# "0": Un seul DVDR, puis le programme s'arrête.
# En ligne de commande: "-mc=".
multicopy=1

# Répertoire temporaire (seulement pour l'extraction par "mplayer" ou "transcode").
# Pour la ligne de commande: "-tmp=".
tmp=/tmp

# Effacement des fichiers VOB en fin d'exécution.
# "0"=ne pas effacer
# "1"=effacer les fichiers VOB
# Pour la ligne de commande: "-d=".
delete=0

# Multiplexeur à utiliser (seulement pour l'extraction par "mplayer" ou "transcode").
# Valeurs possibles: "mplex", "tcmplex".
# Pour la ligne de commande: "-mplex=".
mplex=mplex

# Mode chapitre.
# "0"=titre d'un seul tenant
# "1"=séparer en chapitres, avec lxdvdrip
# "2"=séparer en chapitres, avec tcprobe
# Pour la ligne de commande: "-chap="
chapter=1

# Vérification préalable de l'espace libre.
# "0"=pas de vérification
# "1"=vérifier la place sur le disque dur avant l'extraction
# Pour la ligne de commande: "-free="
free=1

# Signal sonore en fin de rip et de gravure.
# 0=pas Signal, 1=Signal.
playsound=1

# Vitesse de gravure (pour "growisofs" et "cdrecord-prodvd").
# Note: entrer la valeur "0" pour supprimer la commande "-speed="
speed=4

# Paramètre supplémentaire pour "growisofs".
# Entrez "dvdcompat=1" pour appeler "growisofs" avec l'option "-dvd-compat".
# Reportez-vous à "man growisofs" pour plus de détails.
dvdcompat=1

# Paramètre(s) additionnel(s) pour mkisofs.
# A encadrer par des guillemets, comme ceci:
# mkisofs_param="input-charset iso8859-1"
# Sera passé dans l'appel de mkisofs ou growisofs.
mkisofs_param=""

# Option à passer à cdrecord-prodvd/growisofs.
# Cette option doit être entre guillemets "xxx", p.ex.:
# burn_param="-tao"
# Cette option sera utilisée lors de l'appel à cdrecord-prodvd ou growisofs.
burn_param=""

# Paramètres supplémentaires pour "cdrecord-prodvd".
# Note: la clé de sécurité est disponible sur la page web de "cdrecord-prodvd".
burnkey=CDR_SECURITY=insérez_ici_la_clé_de_sécurité

# Ejection du DVD après extraction.
# "0"=ne pas éjecter
# "1"=éjecter le DVD
eject=1

# Formatage du DVD RW avant gravure.
# "0"=pas de formatage préalable
# "1"=formater le DVD RW avant de graver
rw-format=1

# Noms des programmes utilisés.
# Mettez à droite du signe "=" le nom réel (et le chemin si besoin) du programme
# Par exemple:
#   forme courante: "mplayer_name=mplayer"
#   pour préciser le chemin: "mplayer_name=/usr/local/bin/mplayer"
#   et pourquoi pas: "mplayer_name=mon_propre_streamer".
dvdauthor_name=dvdauthor
buffer_name=buffer
#buffer_name=bfr
#buffer_name=mbuffer
tccat_name=tccat
tcextract_name=tcextract
tcrequant_name=tcrequant
mplayer_name=mplayer
mplex_name=mplex
tcmplex_name=tcmplex
spumux_name=spumux
spuunmux_name=spuunmux
dvdbackup_name=dvdbackup_lxdvdrip
# Alternative: dvdbackup_name=vobcopy
mkisofs_name=mkisofs
cdrecord_prodvd_name=cdrecord-prodvd
growisofs_name=growisofs
dvd+rw-format=dvd+rw-format
dvdunauthor_name=dvdunauthor
tcprobe_name=tcprobe
play_cell_name=play_cell_lxdvdrip
vamps_name=vamps_lxdvdrip
eject_name=eject
mpgtx_name=mpgtx
transcode_name=transcode
lxac3scan_name=lxac3scan

# Réglages de dvdwizard.
# dvdwizard permet de doter le DVD d'un menu simple avec
# une liste des chapitres avec images extraites du film et boutons
# pour sélectionner et lancer les titres.
# "dvdwizard=":       1=actif, 0=inactif.
# "dvdwizard_name=":  Nom et chemin d'accès au programme.
# "dvdwizard_bild1=": Image (jpeg, png) de fond d'écran de menu principal (VMGM-Menu)
# "dvdwizard_bild2=": Image (jpeg, png) de fond d'écran de menu des chapitres (VTSM-Menu)
dvdwizard=0
dvdwizard_name=dvdwizard
dvdwizard_bild1=/usr/share/pixmaps/penguin.jpg
dvdwizard_bild2=/usr/share/pixmaps/penguin.jpg
