/*==============================================================================

FICHIER     : [dvdcell.h]

DATE        : 2006/02/0015 21:55:35

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __DVDCELL_H__
#define __DVDCELL_H__
typedef struct
{
	int idx;
	uint32_t newSector;
	uint32_t oldSector;
	uint32_t size;
	int firstAudio[8];
	int firstSubp[32];
	int firstVideo;
	int empty;
} Vobu_t;

typedef struct {
	Vobu_t * vobus;
	int nbVobu;
} VobuArray_t;

typedef struct
{
	int 		idx;
	int		vts;
	ifo_handle_t *	ifo;
	pgc_t * 	pgc;
	uint32_t	startSector;
	uint32_t	lastSector;
	int		selected;
	int		pSelected;
	int 		done;
	int		chapter;
	uint32_t	oldStartSector;
	uint32_t	oldLastSector;
	VobuArray_t	va;
	int 		numVobu;
} Cell_t;

typedef struct {
	Cell_t * cells;
	int nbCells;
} CellArray_t;

typedef struct
{
	int vts;
	ifo_handle_t *	ifo;
	uint32_t	startSector;
	uint32_t	lastSector;
	CellArray_t	ca;
} TitleSet_t;

typedef struct
{
	TitleSet_t * titles;
	int nbTitles;
} TitleArray_t;

#define SECTOR_SZ( c )		( c->lastSector - c->startSector + 1 )

/*@$#[dvdcell.c] global proto. AutoProtoSigV1.1. date: 106/02/15 22:14:57 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
Cell_t *NewCell PROTO((CellArray_t *ca));
TitleSet_t *NewTitleSet PROTO((TitleArray_t *ta));
Vobu_t *NewVobu PROTO((VobuArray_t *va, uint32_t oldSector));
int BuildCells PROTO((int noPisteVideo, CellArray_t *ca));
void FreeCellArray PROTO((CellArray_t *ca));
int CountSelectedCells PROTO((CellArray_t *ca));
void DumpVobus PROTO((Cell_t *c));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/

#endif	/* __DVDCELL_H__ */

