/**
 * \file FormLog.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#include "xformsBC.h"
#include "ControlLog.h"
#include "FormLog.h"
#include "forms/form_browser.h"
#include "gettext.h"
#include FORMS_H_LOCATION

FormLog::FormLog()
	: FormCB<ControlLog, FormBrowser>( _("LaTeX Log"))
{}


void FormLog::update()
{
	bool const buildlog = controller().logfile().first == Buffer::buildlog;

	string const title = buildlog ?
		_("LyX: LaTeX Log") :
		_("LyX: Literate Programming Build Log");
	fl_set_form_title(dialog_->form, title.c_str());

	fl_clear_browser(dialog_->browser);
	int const valid = fl_load_browser(dialog_->browser,
					  controller().logfile().second.c_str());
	if (!valid) {
		string const error = buildlog ?
			_("No LaTeX log file found.") :
			_("No Literate Programming build log file found.");
		fl_add_browser_line(dialog_->browser, error.c_str());
	}
}
