#include <config.h>

#include <cstdlib>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "LString.h"
#include "support/lyxlib.h"
#include "support/filetools.h"
#include "support/lstrings.h"
#include "debug.h"
#include "package.h"

#if !defined(HAVE_MKSTEMP) && defined(HAVE_MKTEMP)
# include <fcntl.h>
# include <sys/stat.h>
#endif

using std::endl;


namespace {

inline
int make_tempfile(char * templ)
{
#if defined(HAVE_MKSTEMP)
	return ::mkstemp(templ);
#elif defined(HAVE_MKTEMP)
	// This probably just barely works...
	::mktemp(templ);
	return ::open(templ, O_RDWR | O_CREAT | O_EXCL, S_IRUSR | S_IWUSR);
#else
#error FIX FIX FIX
#endif
}

} // namespace anon


string const lyx::tempName(string const & dir, string const & mask)
{
	string const tmpdir(dir.empty() ? lyx::package().temp_dir() : dir);
	string tmpfl(AddName(tmpdir, mask));
	tmpfl += tostr(getpid());
	tmpfl += "XXXXXX";

	// The supposedly safe mkstemp version
	char * tmpl = new char[tmpfl.length() + 1]; // + 1 for '\0'
	tmpfl.copy(tmpl, string::npos);
	tmpl[tmpfl.length()] = '\0'; // terminator

	int const tmpf = make_tempfile(tmpl);
	if (tmpf != -1) {
		string const t(tmpl);
		::close(tmpf);
		delete [] tmpl;
		lyxerr[Debug::FILES] << "Temporary file `" << t
				     << "' created." << endl;
		return t;
	} else {
		lyxerr[Debug::FILES]
			<< "LyX Error: Unable to create temporary file."
			<< endl;
		delete [] tmpl;
		return string();
	}
}
