/*
    libMakeMKV - MKV multiplexer library

    Copyright (C) 2009-2010 GuinpinSoft inc <libmkv@makemkv.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
#include <stdint.h>
#include <unistd.h>
#include <alloca.h>
#include <errno.h>
#include <lgpl/httpabi.h>
#include <lgpl/sstring.h>

int posix_launch(char** argv,int fdstdout);

int HTTP_Download(const char* Url,const char* Agent,void* Buffer,uint32_t* Size)
{
    int     pipe_fd[2],err;
    char*   argv[8];
    char    argv0[16],argv1[4],argv2[4],argv3[4],argv4[4];
    char    *lagent,*lurl;
    ssize_t rd;

    if (pipe(pipe_fd))
    {
        return errno|0x80000000;
    }

    lagent = (char*)alloca(strlen(Agent)+1);
    strcpy(lagent,Agent);

    lurl = (char*)alloca(strlen(Url)+1);
    strcpy(lurl,Url);

    strcpy(argv0,"/usr/bin/wget"); argv[0]=argv0;
    strcpy(argv1,"-q"); argv[1]=argv1;
    strcpy(argv2,"-O"); argv[2]=argv2;
    strcpy(argv3,"-"); argv[3]=argv3;
    strcpy(argv4,"-U"); argv[4]=argv4;
    argv[5]=lagent;
    argv[6]=lurl;
    argv[7]=NULL;

    err = posix_launch(argv,pipe_fd[1]);

    close(pipe_fd[1]);

    if (err)
    {
        return err;
    }

    for (uint32_t i=0;i<(*Size);i++)
    {
        rd = (int) read(pipe_fd[0],((char*)Buffer)+i,1);

        if (rd==0)
        {
            close(pipe_fd[0]);
            *Size = i;
            return 0;
        }

        if (rd!=1)
        {
            close(pipe_fd[0]);
            return errno|0x80000000;
        }
    }

    close(pipe_fd[0]);
    return -2;
}

