/*
    libMakeMKV - MKV multiplexer library

    Copyright (C) 2009-2010 GuinpinSoft inc <libmkv@makemkv.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
#include "ffcodec.h"
#include "get_bits.h"
#include "mlp.h"
#include "mpegaudiodecheader.h"

int ffcodec_ff_mlp_read_major_sync(MLPHeaderInfo *mh, const uint8_t* data, unsigned int size)
{
    GetBitContext   gb;

    init_get_bits(&gb,data,size*8);

    ff_mlp_init_crc();

    return ff_mlp_read_major_sync(NULL,mh,&gb);
}

int ffcodec_ff_mpegaudio_decode_header(MPADecodeHeader *s, const uint8_t* data, unsigned int size)
{
    uint32_t header;

    if (size<4) return -2;

    header = AV_RB32(data);

    return ff_mpegaudio_decode_header(s,header);
}

int ffcodec_ff_mpa_check_header( const uint8_t* data, unsigned int size)
{
    uint32_t header;

    if (size<4) return -2;

    header = AV_RB32(data);

    return ff_mpa_check_header(header);
}

