/*
    libMakeMKV - MKV multiplexer library

    Copyright (C) 2009-2010 GuinpinSoft inc <libmkv@makemkv.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
#ifndef FFCODEC_H
#define FFCODEC_H

#include <stdint.h>
#include "mlp_parser.h"
#include "mpegaudio.h"

#ifdef __cplusplus
extern "C" {
#endif

int ffcodec_ff_mlp_read_major_sync(MLPHeaderInfo *mh, const uint8_t* data, unsigned int size);
int ffcodec_ff_mlp_get_chancount(const MLPHeaderInfo *mh);

int ffcodec_ff_mpegaudio_decode_header(MPADecodeHeader *s, const uint8_t* data, unsigned int size);
int ffcodec_ff_mpa_check_header( const uint8_t* data, unsigned int size);

#ifdef __cplusplus
}
#endif

#endif /* FFCODEC_H */

