/*
    libMakeMKV - MKV multiplexer library

    Copyright (C) 2009-2010 GuinpinSoft inc <libmkv@makemkv.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
#ifndef FFCODEC_MISC_H
#define FFCODEC_MISC_H

#include <stdint.h>

#define CONFIG_HARDCODED_TABLES     1
#define CONFIG_SMALL                1
#define ALT_BITSTREAM_READER        1

#define av_pure
#define av_cold

#ifdef _MSC_VER
#define inline              __inline
#define av_always_inline    __inline
#else
#define inline              __inline__
#define av_always_inline    __inline__
#endif

#ifndef AV_RL16
#   define AV_RL16(x)                           \
    ((((const uint8_t*)(x))[1] << 8) |          \
      ((const uint8_t*)(x))[0])
#endif
#ifndef AV_RB32
#   define AV_RB32(x)                           \
    ((((const uint8_t*)(x))[0] << 24) |         \
     (((const uint8_t*)(x))[1] << 16) |         \
     (((const uint8_t*)(x))[2] <<  8) |         \
      ((const uint8_t*)(x))[3])
#endif

static uint32_t bswap_32(uint32_t i)
{
    uint32_t j;
    j =  (i << 24);
    j |= (i <<  8) & 0x00FF0000;
    j |= (i >>  8) & 0x0000FF00;
    j |= (i >> 24);
    return j;
}

#endif /* FFCODEC_MISC_H */

