/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Written by GuinpinSoft inc <makemkvgui@makemkv.com>

    This file is hereby placed into public domain,
    no copyright is claimed.

*/
#ifndef APDEFS_H_INCLUDED
#define APDEFS_H_INCLUDED

static const unsigned int AP_MaxCdromDevices=16;
static const unsigned int AP_Progress_MaxValue=65536;
static const unsigned int AP_Progress_MaxLayoutItems=10;
static const unsigned int AP_UIMSG_BOX_MASK=3854;
static const unsigned int AP_UIMSG_BOXOK=260;
static const unsigned int AP_UIMSG_BOXERROR=516;
static const unsigned int AP_UIMSG_BOXWARNING=1028;
static const unsigned int AP_UIMSG_BOXYESNO=776;
static const unsigned int AP_UIMSG_BOXYESNO_ERR=1288;
static const unsigned int AP_UIMSG_YES=0;
static const unsigned int AP_UIMSG_NO=1;
static const unsigned int AP_UIMSG_DEBUG=32;
static const unsigned int AP_UIMSG_HIDDEN=64;
static const unsigned int AP_UIMSG_EVENT=128;
static const unsigned int AP_vastr_Name=0;
static const unsigned int AP_vastr_Version=1;
static const unsigned int AP_vastr_Platform=2;
static const unsigned int AP_vastr_Build=3;
static const unsigned int AP_vastr_KeyType=4;
static const unsigned int AP_vastr_KeyFeatures=5;
static const unsigned int AP_vastr_KeyExpiration=6;
static const unsigned int AP_vastr_EvalState=7;
static const unsigned int AP_vastr_ProgExpiration=8;
static const unsigned int AP_vastr_LatestVersion=9;
//
typedef enum _AP_ItemAttributeId
{
  ap_iaUnknown=0,
  ap_iaType=1,
  ap_iaName=2,
  ap_iaLangCode=3,
  ap_iaLangName=4,
  ap_iaCodecId=5,
  ap_iaCodecShort=6,
  ap_iaCodecLong=7,
  ap_iaChapterCount=8,
  ap_iaDuration=9,
  ap_iaDiskSize=10,
  ap_iaDiskSizeBytes=11,
  ap_iaStreamTypeExtension=12,
  ap_iaBitrate=13,
  ap_iaAudioChannelsCount=14,
  ap_iaAngleInfo=15,
  ap_iaSourceFileName=16,
  ap_iaAudioSampleRate=17,
  ap_iaAudioSampleSize=18,
  ap_iaVideoSize=19,
  ap_iaVideoAspectRatio=20,
  ap_iaVideoFrameRate=21,
  ap_iaStreamFlags=22,
  ap_iaDateTime=23,
  ap_iaMaxValue
} AP_ItemAttributeId;

static const unsigned int AP_DskFsFlagDvdFilesPresent=1;
static const unsigned int AP_DskFsFlagHdvdFilesPresent=2;
static const unsigned int AP_DskFsFlagBlurayFilesPresent=4;
static const unsigned int AP_DskFsFlagAacsFilesPresent=8;
static const unsigned int AP_DskFsFlagBdsvmFilesPresent=16;
static const unsigned int AP_DskFsFlagDiskIsLoading=256;
static const unsigned int AP_DskFsFlagDiskIsAbsent=512;


static const unsigned int AP_Notify_UpdateLayoutFlag_NoTime=1;


static const unsigned int AP_AVStreamFlag_DirectorsComments=1;
static const unsigned int AP_AVStreamFlag_AlternateDirectorsComments=2;
static const unsigned int AP_AVStreamFlag_ForVisuallyImpaired=4;
static const unsigned int AP_AVStreamFlag_CoreAudio=256;
static const unsigned int AP_AVStreamFlag_SecondaryAudio=512;
static const unsigned int AP_AVStreamFlag_HasCoreAudio=1024;
static const unsigned int AP_AVStreamFlag_DerivedStream=2048;
static const unsigned int AP_AVStreamFlag_ForcedSubtitles=4096;


static const unsigned int AP_APP_LOC_POGZ=1;
static const unsigned int AP_APP_LOC_MAX=100;


static const unsigned long APP_DUMP_DONE_PARTIAL=5004;
static const unsigned long APP_DUMP_DONE=5005;
static const unsigned long APP_INIT_FAILED=5009;
static const unsigned long APP_ASK_FOLDER_CREATE=5013;
static const unsigned long APP_FOLDER_INVALID=5016;
static const unsigned long PROGRESS_APP_SAVE_MKV_FREE_SPACE=5033;
static const unsigned long APP_BACKUP_FAILED=5069;
static const unsigned long APP_BACKUP_COMPLETED=5070;
static const unsigned long APP_IFACE_TITLE=6000;
static const unsigned long APP_CAPTION_MSG=6001;
static const unsigned long APP_ABOUTBOX_TITLE=6002;
static const unsigned long APP_IFACE_OPENFILE_TITLE=6003;
static const unsigned long APP_SETTINGDLG_TITLE=6135;
static const unsigned long APP_BACKUPDLG_TITLE=6136;
static const unsigned long APP_IFACE_OPENFILE_FILTER=6004;
static const unsigned long APP_IFACE_OPENFOLDER_TITLE=6005;
static const unsigned long APP_IFACE_OPENFOLDER_INFO_TITLE=6006;
static const unsigned long APP_IFACE_PROGRESS_TITLE=6038;
static const unsigned long APP_IFACE_PROGRESS_ELAPSED_ONLY=6039;
static const unsigned long APP_IFACE_PROGRESS_ELAPSED_ETA=6040;
static const unsigned long APP_IFACE_ACT_OPENFILES_NAME=6010;
static const unsigned long APP_IFACE_ACT_OPENFILES_SKEY=6011;
static const unsigned long APP_IFACE_ACT_OPENFILES_STIP=6012;
static const unsigned long APP_IFACE_ACT_CLOSEDISK_NAME=6013;
static const unsigned long APP_IFACE_ACT_CLOSEDISK_STIP=6014;
static const unsigned long APP_IFACE_ACT_SETFOLDER_NAME=6015;
static const unsigned long APP_IFACE_ACT_SETFOLDER_STIP=6016;
static const unsigned long APP_IFACE_ACT_SAVEALLMKV_NAME=6017;
static const unsigned long APP_IFACE_ACT_SAVEALLMKV_STIP=6018;
static const unsigned long APP_IFACE_ACT_CANCEL_NAME=6036;
static const unsigned long APP_IFACE_ACT_CANCEL_STIP=6037;
static const unsigned long APP_IFACE_ACT_STREAMING_NAME=6131;
static const unsigned long APP_IFACE_ACT_STREAMING_STIP=6132;
static const unsigned long APP_IFACE_ACT_BACKUP_NAME=6133;
static const unsigned long APP_IFACE_ACT_BACKUP_STIP=6134;
static const unsigned long APP_IFACE_ACT_QUIT_NAME=6019;
static const unsigned long APP_IFACE_ACT_QUIT_SKEY=6020;
static const unsigned long APP_IFACE_ACT_QUIT_STIP=6021;
static const unsigned long APP_IFACE_ACT_ABOUT_NAME=6022;
static const unsigned long APP_IFACE_ACT_ABOUT_STIP=6023;
static const unsigned long APP_IFACE_ACT_SETTINGS_NAME=6042;
static const unsigned long APP_IFACE_ACT_SETTINGS_STIP=6043;
static const unsigned long APP_IFACE_ACT_HELPPAGE_NAME=6045;
static const unsigned long APP_IFACE_ACT_HELPPAGE_STIP=6046;
static const unsigned long APP_IFACE_ACT_REGISTER_NAME=6047;
static const unsigned long APP_IFACE_ACT_REGISTER_STIP=6048;
static const unsigned long APP_IFACE_ACT_PURCHASE_NAME=6145;
static const unsigned long APP_IFACE_ACT_PURCHASE_STIP=6146;
static const unsigned long APP_IFACE_ACT_EJECT_NAME=6052;
static const unsigned long APP_IFACE_ACT_EJECT_STIP=6053;
static const unsigned long APP_IFACE_ACT_OPENDISC_DVD=6062;
static const unsigned long APP_IFACE_ACT_OPENDISC_HDDVD=6063;
static const unsigned long APP_IFACE_ACT_OPENDISC_BRAY=6064;
static const unsigned long APP_IFACE_ACT_OPENDISC_LOADING=6065;
static const unsigned long APP_IFACE_ACT_TTREE_TOGGLE=6066;
static const unsigned long APP_IFACE_ACT_TTREE_SELECT_ALL=6067;
static const unsigned long APP_IFACE_ACT_TTREE_UNSELECT_ALL=6068;
static const unsigned long APP_IFACE_MENU_FILE=6030;
static const unsigned long APP_IFACE_MENU_VIEW=6031;
static const unsigned long APP_IFACE_MENU_HELP=6032;
static const unsigned long APP_IFACE_MENU_TOOLBAR=6034;
static const unsigned long APP_IFACE_MENU_SETTINGS=6044;
static const unsigned long APP_IFACE_MENU_DRIVES=6035;
static const unsigned long APP_IFACE_CANCEL_CONFIRM=6041;
static const unsigned long APP_IFACE_FATAL_COMM=6050;
static const unsigned long APP_IFACE_FATAL_MEM=6051;
static const unsigned long APP_IFACE_GUI_VERSION=6054;
static const unsigned long APP_IFACE_LATEST_VERSION=6158;
static const unsigned long APP_IFACE_LICENSE_TYPE=6055;
static const unsigned long APP_IFACE_EVAL_STATE=6056;
static const unsigned long APP_IFACE_EVAL_EXPIRATION=6057;
static const unsigned long APP_IFACE_PROG_EXPIRATION=6142;
static const unsigned long APP_IFACE_VIDEO_FOLDER_NAME_WIN=6058;
static const unsigned long APP_IFACE_VIDEO_FOLDER_NAME_MAC=6059;
static const unsigned long APP_IFACE_VIDEO_FOLDER_NAME_LINUX=6060;
static const unsigned long APP_IFACE_DEFAULT_FOLDER_NAME=6061;
static const unsigned long APP_IFACE_MAIN_FRAME_INFO=6069;
static const unsigned long APP_IFACE_MAIN_FRAME_MAKE_MKV=6070;
static const unsigned long APP_IFACE_EMPTY_FRAME_SOURCE=6071;
static const unsigned long APP_IFACE_EMPTY_FRAME_TYPE=6072;
static const unsigned long APP_IFACE_EMPTY_FRAME_LABEL=6073;
static const unsigned long APP_IFACE_EMPTY_FRAME_PROTECTION=6074;
static const unsigned long APP_IFACE_EMPTY_FRAME_INFO=6075;
static const unsigned long APP_IFACE_REGISTER_TEXT=6076;
static const unsigned long APP_IFACE_REGISTER_CODE_INCORRECT=6077;
static const unsigned long APP_IFACE_REGISTER_CODE_NOT_SAVED=6078;
static const unsigned long APP_IFACE_REGISTER_CODE_SAVED=6079;
static const unsigned long APP_IFACE_SETTINGS_IO_OPTIONS=6080;
static const unsigned long APP_IFACE_SETTINGS_IO_AUTO=6081;
static const unsigned long APP_IFACE_SETTINGS_IO_READ_RETRY=6082;
static const unsigned long APP_IFACE_SETTINGS_IO_READ_BUFFER=6083;
static const unsigned long APP_IFACE_SETTINGS_IO_NO_DIRECT_ACCESS=6150;
static const unsigned long APP_IFACE_SETTINGS_IO_DARWIN_K2_WORKAROUND=6151;
static const unsigned long APP_IFACE_SETTINGS_DVD_OPTIONS=6084;
static const unsigned long APP_IFACE_SETTINGS_DVD_AUTO=6085;
static const unsigned long APP_IFACE_SETTINGS_DVD_MIN_LENGTH=6086;
static const unsigned long APP_IFACE_SETTINGS_DVD_SP_REMOVE=6087;
static const unsigned long APP_IFACE_SETTINGS_STREAM_OPTIONS=6160;
static const unsigned long APP_IFACE_SETTINGS_STREAM_ENABLE_UPNP=6161;
static const unsigned long APP_IFACE_SETTINGS_STREAM_BIND_IP=6162;
static const unsigned long APP_IFACE_SETTINGS_STREAM_BIND_PORT=6163;
static const unsigned long APP_IFACE_SETTINGS_AACS_KEY_DIR=6088;
static const unsigned long APP_IFACE_SETTINGS_BDP_SVQ_DIR=6122;
static const unsigned long APP_IFACE_SETTINGS_BDP_DUMP_DIR=6123;
static const unsigned long APP_IFACE_SETTINGS_BDP_MISC=6129;
static const unsigned long APP_IFACE_SETTINGS_BDP_DUMP_ALWAYS=6130;
static const unsigned long APP_IFACE_SETTINGS_DEST_TYPE_NONE=6089;
static const unsigned long APP_IFACE_SETTINGS_DEST_TYPE_AUTO=6090;
static const unsigned long APP_IFACE_SETTINGS_DEST_TYPE_SEMIAUTO=6091;
static const unsigned long APP_IFACE_SETTINGS_DEST_TYPE_CUSTOM=6092;
static const unsigned long APP_IFACE_SETTINGS_DESTDIR=6093;
static const unsigned long APP_IFACE_SETTINGS_GENERAL_MISC=6094;
static const unsigned long APP_IFACE_SETTINGS_LOG_DEBUG_MSG=6095;
static const unsigned long APP_IFACE_SETTINGS_ENABLE_SITE_ACCESS=6149;
static const unsigned long APP_IFACE_SETTINGS_TAB_GENERAL=6096;
static const unsigned long APP_IFACE_SETTINGS_MSG_FAILED=6097;
static const unsigned long APP_IFACE_SETTINGS_MSG_RESTART=6098;
static const unsigned long APP_IFACE_SETTINGS_TAB_LANGUAGE=6152;
static const unsigned long APP_IFACE_SETTINGS_LANG_INTERFACE=6153;
static const unsigned long APP_IFACE_SETTINGS_LANG_PREFERRED=6154;
static const unsigned long APP_IFACE_SETTINGS_LANGUAGE_OPTIONS=6155;
static const unsigned long APP_IFACE_SETTINGS_LANGUAGE_AUTO=6156;
static const unsigned long APP_IFACE_SETTINGS_LANGUAGE_NONE=6157;
static const unsigned long APP_IFACE_BACKUPDLG_TEXT_CAPTION=6137;
static const unsigned long APP_IFACE_BACKUPDLG_TEXT=6138;
static const unsigned long APP_IFACE_BACKUPDLG_FOLDER=6139;
static const unsigned long APP_IFACE_BACKUPDLG_OPTIONS=6147;
static const unsigned long APP_IFACE_BACKUPDLG_DECRYPT=6148;
static const unsigned long APP_IFACE_DRIVEINFO_LOADING=6100;
static const unsigned long APP_IFACE_DRIVEINFO_WAIT=6101;
static const unsigned long APP_IFACE_DRIVEINFO_NODISC=6102;
static const unsigned long APP_IFACE_DRIVEINFO_DATADISC=6103;
static const unsigned long APP_IFACE_DRIVEINFO_NONE=6104;
static const unsigned long APP_IFACE_ITEMLINE_TYPE=6105;
static const unsigned long APP_IFACE_ITEMLINE_NAME=6106;
static const unsigned long APP_IFACE_ITEMLINE_SRCNAME=6107;
static const unsigned long APP_IFACE_ITEMLINE_ANGLE=6108;
static const unsigned long APP_IFACE_ITEMLINE_LANGUAGE=6109;
static const unsigned long APP_IFACE_ITEMLINE_DURATION=6110;
static const unsigned long APP_IFACE_ITEMLINE_CHAPTERS=6111;
static const unsigned long APP_IFACE_ITEMLINE_CODEC=6112;
static const unsigned long APP_IFACE_ITEMLINE_CHANNELS=6113;
static const unsigned long APP_IFACE_ITEMLINE_SAMPLERATE=6114;
static const unsigned long APP_IFACE_ITEMLINE_SAMPLEBITS=6115;
static const unsigned long APP_IFACE_ITEMLINE_RESOLUTION=6116;
static const unsigned long APP_IFACE_ITEMLINE_ASPECT=6117;
static const unsigned long APP_IFACE_ITEMLINE_FRAMERATE=6118;
static const unsigned long APP_IFACE_ITEMLINE_FLAGS=6124;
static const unsigned long APP_IFACE_ITEMLINE_TIMESTAMP=6141;
static const unsigned long APP_IFACE_FLAGS_DIRECTORS_COMMENTS=6125;
static const unsigned long APP_IFACE_FLAGS_ALT_DIRECTORS_COMMENTS=6126;
static const unsigned long APP_IFACE_FLAGS_SECONDARY_AUDIO=6127;
static const unsigned long APP_IFACE_FLAGS_FOR_VISUALLY_IMPAIRED=6128;
static const unsigned long APP_IFACE_FLAGS_CORE_AUDIO=6143;
static const unsigned long APP_IFACE_FLAGS_FORCED_SUBTITLES=6144;
static const unsigned long APP_IFACE_ITEMINFO_SOURCE=6119;
static const unsigned long APP_IFACE_ITEMINFO_TITLE=6120;
static const unsigned long APP_IFACE_ITEMINFO_TRACK=6121;
static const unsigned long APP_TTREE_TITLE=6200;
static const unsigned long APP_TTREE_VIDEO=6201;
static const unsigned long APP_TTREE_AUDIO=6202;
static const unsigned long APP_TTREE_SUBPICTURE=6203;
static const unsigned long APP_TTREE_FORCED_SUBTITLES=6211;
static const unsigned long APP_TTREE_HDR_TYPE=6204;
static const unsigned long APP_TTREE_HDR_DESC=6205;
static const unsigned long DVD_TYPE_DISK=6206;
static const unsigned long BRAY_TYPE_DISK=6209;
static const unsigned long APP_TTREE_CHAP_DESC=6207;
static const unsigned long APP_TTREE_ANGLE_DESC=6210;


typedef enum _ApSettingId
{
  apset_Unknown=0,
  apset_dvd_MinimumTitleLength ,
  apset_dvd_DebugUseOnlyIfo ,
  apset_dvd_SPRemoveMethod ,
  apset_aacs_KeyFilesDir ,
  apset_app_Key ,
  apset_app_KeyHash ,
  apset_io_ErrorRetryCount ,
  apset_io_IgnoreReadErrors ,
  apset_io_RBufSizeMB ,
  apset_io_TIPS_Server ,
  apset_io_NoDirectAccess ,
  apset_io_DarwinK2Workaround ,
  apset_fs_ForceIsoForUDF102 ,
  apset_app_DestinationType ,
  apset_app_DestinationDir ,
  apset_app_ShowDebug ,
  apset_app_DebugKey ,
  apset_app_PreferredLanguage ,
  apset_app_BackupDecrypted ,
  apset_app_InterfaceLanguage ,
  apset_app_UpdateEnable ,
  apset_app_UpdateLastCheck ,
  apset_bdplus_SvqDir ,
  apset_bdplus_DumpDir ,
  apset_bdplus_DumpAlways ,
  apset_stream_EnableUPNP ,
  apset_stream_BindIp ,
  apset_stream_BindPort ,
  apset_MaxValue
} ApSettingId;

#endif // APDEFS_H_INCLUDED

