/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Written by GuinpinSoft inc <makemkvgui@makemkv.com>

    This file is hereby placed into public domain,
    no copyright is claimed.

*/
#ifndef LGPL_APPSHARED_H_INCLUDED
#define LGPL_APPSHARED_H_INCLUDED

inline void AppMakeCorrectFileName(uint16_t *Str)
{
    uint16_t *src,*dst;

    src = dst = Str;

    while(*src!=0)
    {
        uint16_t c;

        c = *(src++);

        if ((c<=' ')  || 
            (c==0x7f) ||
            (c==0x2122) || // TM
            (c==0xA9) ||   // (c)
            (c==0xAE) ||   // (R)
            (c=='#')  ||
            (c=='/')  ||
            (c=='\\') ||
            (c=='"')  ||
            (c==':')  ||
            (c=='$')  ||
            (c=='*')  ||
            (c=='?')  ||
            (c=='.')  ||
            (c==':')  ||
            (c==';')
            )
        {
            c='_';
        }
        if (c==0x2013)
        {
            c='-';
        }

        if ( (dst!=Str) && (c=='_') && (*(dst-1)=='_') )
        {
            // skip
        } else {
            *(dst++) = c;
        }
    }
    while( (dst!=Str) && (*(dst-1)=='_') )
    {
        dst--;
    }
    *dst=0;
}



#endif // LGPL_APPSHARED_H_INCLUDED

