/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <stdint.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/param.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <mach-o/dyld.h>
#include <crt_externs.h>

int posix_getmyname(char* buffer,int length)
{
    bzero(buffer,length);

    uint32_t len=length;
    if (0!=_NSGetExecutablePath(buffer,&len))
    {
        return 0;
    }
    buffer[length-1]=0;

    return (int) strlen(buffer);
}

int posix_launch(char** aargv,int fdstdout)
{
    pid_t   pid;

    fflush(stdout);

    pid = fork();

    if (pid==-1)
    {
        return -1;
    }
    if (pid != 0)
    {
        return 0;
    }

    if (fdstdout!=STDOUT_FILENO)
    {
        dup2(fdstdout,STDOUT_FILENO);
    }
   
    char ** envp = *_NSGetEnviron();

    execve(aargv[0],aargv,envp);

    fprintf(stdout,"execve failed err=%u\n",errno);

    exit(2);
    return 0;
}

