/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <stdint.h>
#include <unistd.h>
#include <errno.h>
#include <spawn.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/time.h>

#include <stdio.h>

int posix_getmyname(char* buffer,int length)
{
    return (int) readlink("/proc/self/exe",buffer,length);
}

int posix_launch(char** argv,int fdstdout)
{
    posix_spawn_file_actions_t  spawn_actions;
    posix_spawnattr_t           spawn_attr;
    pid_t   pid;
    int     err;

    if (posix_spawnattr_init(&spawn_attr))
    {
        return -1;
    }
    if (posix_spawnattr_setflags(&spawn_attr,POSIX_SPAWN_SETPGROUP))
    {
        return -1;
    }
    if (posix_spawnattr_setpgroup(&spawn_attr,0))
    {
        return -1;
    }
    if (posix_spawn_file_actions_init(&spawn_actions))
    {
        return -1;
    }
    if (posix_spawn_file_actions_adddup2(&spawn_actions,fdstdout,STDOUT_FILENO))
    {
        return -1;
    }

    err = posix_spawn(&pid,argv[0],&spawn_actions,&spawn_attr,argv,environ);

    posix_spawn_file_actions_destroy(&spawn_actions);
    posix_spawnattr_destroy(&spawn_attr);
    
    return err;
}

