/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <lgpl/aproxy.h>
#include <windows.h>
#include <winnt.h>
#include <lgpl/smem.h>

extern bool AppEngMain(const char *ver,bool);

static DWORD WINAPI DebugEngMainThreadProc(LPVOID lpParameter)
{
    AppEngMain((const char*)lpParameter,false);
    CloseHandle(GetStdHandle(STD_OUTPUT_HANDLE));
    return 0;
}

typedef BOOL (WINAPI *LPFN_ISWOW64PROCESS) (HANDLE, PBOOL);

static bool IsWow64()
{
    BOOL bIsWow64 = FALSE;
    LPFN_ISWOW64PROCESS fnIsWow64Process;

    if (0!=GetEnvironmentVariableA("APROXY_FORCE_32BIT",NULL,0))
    {
        return false;
    }

    fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress(
        GetModuleHandleW(L"KERNEL32"),"IsWow64Process");
  
    if (NULL != fnIsWow64Process)
    {
        if (!fnIsWow64Process(GetCurrentProcess(),&bIsWow64))
        {
            // handle error
            bIsWow64 = FALSE;
        }
    }
    return (FALSE!=bIsWow64);
}


int  ApSpawnApp(const char* verstr,const char* AppName,char* response,size_t responselength)
{
    wchar_t appname[1024];
    wchar_t cmdline[64];

    if (GetModuleFileNameW(NULL,appname,1024)>1023) return 100001;
    
    wchar_t* app_end = appname + wcslen(appname) - 1;
    while( (*app_end!='\\') && (*app_end!='/') )
    {
        app_end--;
    }
    app_end++;
    const char *p = AppName;
    while(*p!=0) { *(app_end++) = *(p++); };

    if ( (IsWow64()) && true )
    {
        wcscpy(app_end,L"64.exe");
    } else {
        wcscpy(app_end,L".exe");
    }

    memcpy(cmdline,L"xxx guiserver ",14*sizeof(wchar_t));
    const char* pv = verstr;
    wchar_t* pc = cmdline+14;
    while(*pv!=0)
    {
        *(pc++)=*(pv++);
    }
    *pc=0;

    STARTUPINFOW si;
    PROCESS_INFORMATION pi;
    HANDLE  hin;
    SECURITY_ATTRIBUTES pipe_si;

    memset(&pipe_si,0,sizeof(pipe_si));
    pipe_si.nLength=sizeof(pipe_si);
    pipe_si.bInheritHandle=TRUE;

    memset(&si,0,sizeof(si));
    si.cb=sizeof(si);
    si.dwFlags = STARTF_USESTDHANDLES;

    if (0==CreatePipe(&hin,&si.hStdOutput,&pipe_si,0)) 
    {
        return 0x10000000|GetLastError();
    }

#ifdef APP_DEBUG_INPROC
    SetStdHandle(STD_OUTPUT_HANDLE,si.hStdOutput);
    pi.hThread=CreateThread(NULL,0,DebugEngMainThreadProc,(LPVOID)verstr,0,NULL);
    if (NULL==pi.hThread) 
    {
        return 0x20000000|GetLastError();
    };
#else
    if (0==CreateProcessW(appname,cmdline,NULL,NULL,TRUE,DETACHED_PROCESS,NULL,NULL,&si,&pi)) 
    {
        return 0x30000000|GetLastError();
    }

    CloseHandle(pi.hThread);
    CloseHandle(pi.hProcess);
    CloseHandle(si.hStdOutput);
#endif

    // read answer
    for (unsigned int i=0;i<(responselength-1);i++)
    {
        DWORD rd;

        do {
            if (0==ReadFile(hin,response+i,1,&rd,NULL)) 
            {
                return 0x40000000|GetLastError();
            }
        } while(0==rd);

        if (response[i]=='$')
        {
            response[i]=0;

            // break pipe
            CloseHandle(hin);
            return 0;
        }
    }

    return 0x50000000|GetLastError();
}

void* ApOpenShmem(const char *name)
{
    uintptr_t v=0;

    while(*name!=0)
    {
        v<<=4;
        v+= (*name-'a');
        name++;
    }

    HANDLE hs = (HANDLE)(void*)v;
    if (NULL==hs) return NULL;
    return MapViewOfFile(hs,FILE_MAP_WRITE,0,0,0);
}

bool ApOpenSgrp(AP_SGRP *sgrp,const uint64_t* data)
{
    sgrp->a_id = (uintptr_t) data[0];
    sgrp->b_id = (uintptr_t) data[1];

    return true;
}

bool ApSemInc(AP_SGRP *sgrp,uintptr_t sid)
{
    if (0==ReleaseSemaphore((HANDLE)(void*)sid,1,NULL)) return false;
    return true;
}

bool ApSemDec(AP_SGRP *sgrp,uintptr_t sid)
{
    DWORD r,w;

#ifdef APP_DEBUG_INPROC
    w = INFINITE;
#else
    w = (AP_SEM_TIMEOUT*1000);
#endif

    r = WaitForSingleObject((HANDLE)(void*)sid,w);

    return (r==WAIT_OBJECT_0);
}

uintptr_t ApDebugOpen(const char* name)
{
    HANDLE handle = CreateFileA(name,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,0,NULL);
    if (handle==INVALID_HANDLE_VALUE) return 0;
    return (uintptr_t)handle;
}

void ApDebugOut(uintptr_t file,const char* string)
{
    DWORD written;
    if (file==0) return;

    WriteFile((HANDLE)file,string,(DWORD)strlen(string),&written,NULL);
    FlushFileBuffers((HANDLE)file);
}

