/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <QtGui/QtGui>
#include "backupdlg.h"
#include "mainwnd.h"
#include <lgpl/sstring.h>

CBackupDialog::CBackupDialog(CApClient* ap_client,IIconPath* iconPath,QIcon* icon,QWidget *parent) : QDialog(parent)
{
    setWindowIcon(*icon);
    setWindowTitle(UI_QSTRING(APP_BACKUPDLG_TITLE));

    client = ap_client;
    backupDecrypt = ap_client->GetSettingInt(apset_app_BackupDecrypted);

    QLabel* labelText = new QLabel();
    labelText->setTextFormat(Qt::PlainText);
    labelText->setWordWrap(true);
    labelText->setText(UI_QSTRING(APP_IFACE_BACKUPDLG_TEXT));

    backupDir = new CDirSelectBox(UI_QSTRING(APP_IFACE_BACKUPDLG_FOLDER),iconPath);
    buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel , Qt::Horizontal);

    QGroupBox* box = new QGroupBox(UI_QSTRING(APP_IFACE_BACKUPDLG_TEXT_CAPTION));
    QBoxLayout *blay = new QVBoxLayout();
    blay->addWidget(labelText);
    box->setLayout(blay);

    QGroupBox* obox = new QGroupBox(UI_QSTRING(APP_IFACE_BACKUPDLG_OPTIONS));
    QBoxLayout *oblay = new QVBoxLayout();
    check_Decrypt = new QCheckBox(UI_QSTRING(APP_IFACE_BACKUPDLG_DECRYPT));
    check_Decrypt->setChecked(backupDecrypt>0);
    oblay->addWidget(check_Decrypt,0,0);
    obox->setLayout(oblay);

    QBoxLayout *lay = new QVBoxLayout();
    lay->addWidget(box);
    lay->addWidget(obox);
    lay->addWidget(backupDir);
    lay->addStretch(10);
    lay->addWidget(buttonBox);
    this->setLayout(lay);

    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    connect(this, SIGNAL(accepted()) , this , SLOT(SlotAccepted()));
};

void CBackupDialog::SlotAccepted()
{
    int newDecrypt = check_Decrypt->isChecked()?1:0;
    if (backupDecrypt!=newDecrypt)
    {
        client->SetSettingInt(apset_app_BackupDecrypted,newDecrypt);
        client->SaveSettings();
    }
    backupDecrypt = newDecrypt;
}

