/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <QtGui/QtGui>
#include "dirselectbox.h"
#include "qtapp.h"
#include <QtExt/NativeFileDialog.h>

CDirSelectBox::CDirSelectBox(const QString &Name, IIconPath* iconPath, QWidgetList widgets , QWidget *parent) : QGroupBox(Name,parent)
{
    lineEditDir = new QLineEdit();
    connect(lineEditDir,SIGNAL(textChanged(const QString &)),this,SLOT(SlotTextChanged(const QString &)));
    QGridLayout *lay = new QGridLayout();

    memset(radioButtons,0,sizeof(radioButtons));

    unsigned int row =0;
    for (QWidgetList::iterator it=widgets.begin();it!=widgets.end();it++)
    {
        QAbstractButton* btn;
        btn = qobject_cast<QAbstractButton *>(*it);
        radioButtons[row] = btn;
        lay->addWidget(btn,row,0);
        row++;
        connect(btn, SIGNAL(toggled(bool)) , this , SLOT(SlotRadioToggled()) );
    }

    lay->addWidget(lineEditDir,row,0);
    lay->setColumnStretch(0,2);

    static QIcon set_folder_icon;
    static bool  set_folder_icon_initialized=false;

    if (false==set_folder_icon_initialized)
    {
        set_folder_icon.addFile(iconPath->IconPath(":/trolltech/styles/commonstyle/images/dirclosed-128.png"),QSize(128,128));
        set_folder_icon.addFile(iconPath->IconPath(":/trolltech/styles/commonstyle/images/dirclosed-32.png"),QSize(32,32));
        set_folder_icon.addFile(iconPath->IconPath(":/trolltech/styles/commonstyle/images/dirclosed-16.png"),QSize(16,16));
        set_folder_icon_initialized=true;
    }

    toolButtonAction  = new QAction(set_folder_icon, UI_QSTRING(APP_IFACE_ACT_SETFOLDER_NAME), this);
    toolButtonAction->setStatusTip(UI_QSTRING(APP_IFACE_ACT_SETFOLDER_STIP));
    connect(toolButtonAction, SIGNAL(triggered()), this, SLOT(SlotButtonPressed()));

    toolButtonSelect = new QToolButton();
    toolButtonSelect->setDefaultAction(toolButtonAction);
    lay->addWidget(toolButtonSelect,row,1);

    this->setLayout(lay);

    validState = false;
    EmitValidChanged();
}

void CDirSelectBox::setIndexValue(int Index)
{
    if (Index>=MaxRadioButtons) return;
    if (NULL==radioButtons[Index]) return;
    radioButtons[Index]->setChecked(true);
}

int CDirSelectBox::getIndexValue()
{
    for (int i=0;i<MaxRadioButtons;i++)
    {
        if (NULL==radioButtons[i]) return -1;
        if (radioButtons[i]->isChecked()) return i;
    }
    return -1;
}

void CDirSelectBox::SlotButtonPressed()
{
    QString dir = QNativeFileDialog::getExistingDirectory(
        this,
        UI_QSTRING(APP_IFACE_OPENFOLDER_TITLE),
        lineEditDir->text());
    
    if ( (dir.isEmpty()) || (dir.isNull()) ) return;

    setText(dir);
}

void CDirSelectBox::setText(const QString &Text)
{
    lineEditDir->setText(Text);
    EmitValidChanged();
    emit SignalChanged();
}

QAction* CDirSelectBox::selectDialogAction()
{
    return toolButtonAction;
}

bool CDirSelectBox::IsDirValid()
{
    return (false==lineEditDir->text().isEmpty());

}

QString CDirSelectBox::text()
{
    return lineEditDir->text();
}

void CDirSelectBox::SlotTextChanged(const QString &str)
{
    emit SignalChanged();
    EmitValidChanged();
}

void CDirSelectBox::EmitValidChanged()
{
    bool vs = IsDirValid();
    if (vs != validState)
    {
        validState = vs;
        emit SignalDirValidChanged();
    }
}

void CDirSelectBox::SlotRadioToggled()
{
    emit SignalIndexChanged();
}

void CDirSelectBox::setDirEnabled(bool Enabled)
{
    lineEditDir->setEnabled(Enabled);
    toolButtonAction->setEnabled(Enabled);
}



