/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#ifndef APP_DIRSELECTBOX_H
#define APP_DIRSELECTBOX_H

#include <QtGui/QtGui>
#include "qtapp.h"

class CDirSelectBox : public QGroupBox
{
    Q_OBJECT

private:
    QLineEdit*   lineEditDir;
    QToolButton* toolButtonSelect;
    QAction*     toolButtonAction;
    bool         validState;

private:

    static const unsigned int MaxRadioButtons = 5;
    QAbstractButton*    radioButtons[MaxRadioButtons];

public:
    CDirSelectBox(const QString &Name, IIconPath* iconPath, QWidgetList widgets = QWidgetList(), QWidget *parent = 0);
    void setIndexValue(int Index);
    int getIndexValue();
    bool IsDirValid();
    void setText(const QString &Text);
    QString text();
    QAction* selectDialogAction();
    void setDirEnabled(bool Enabled);

private:
    void EmitValidChanged();

private slots:
    void SlotButtonPressed();
    void SlotTextChanged(const QString &str);
    void SlotRadioToggled();

signals:
    void SignalChanged();
    void SignalDirValidChanged();
    void SignalIndexChanged();

};

#endif // APP_DIRSELECTBOX_H

