/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include "qtapp.h"

#if defined(_linux_)
#include <sys/vfs.h>
#elif defined(_darwin_)
#include <sys/param.h>
#include <sys/mount.h>
#endif

QString get_auto_path()
{
    QString rtn;
    const char* home;
    
    home = getenv("HOME");
    if (home==NULL)
    {
	    return QLatin1String("/tmp/Videos");
    }
    
    rtn.reserve(strlen(home)+16);
    rtn.append(QLatin1String(home));

    rtn.append(QChar::fromLatin1('/'));
#ifdef _darwin_
    rtn.append(UI_QSTRING(APP_IFACE_VIDEO_FOLDER_NAME_MAC));
#else
    rtn.append(UI_QSTRING(APP_IFACE_VIDEO_FOLDER_NAME_LINUX));
#endif

    return rtn;
}

uint64_t get_free_space(const utf16_t* Folder)
{
    uint64_t fspace;
    struct statfs st;
    QString folder_str;
    
    folder_str = QStringFromUtf16(Folder);
    
    fspace=0;
    fspace--;
    
    if (statfs((const char*)folder_str.toUtf8(),&st))
    {
	return fspace;
    }
    
    fspace = st.f_bavail;
    fspace *= st.f_bsize;
    
    return fspace;
}

