/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include "qtapp.h"
#include <windows.h>
#include <winnt.h>
#include <algorithm>
#include <vector>

QT_C_ASSERT( sizeof(wchar_t) == sizeof(utf16_t) );

typedef struct _d_rank
{
    int type_rank;
    int fs_rank;
    ULARGE_INTEGER free_bytes;
    ULARGE_INTEGER total_bytes;
    char letter;
} d_rank;

// fixed free NTFS/fat32/fat size
static bool rank_compare (const d_rank & l , const d_rank & r)
{
    if (l.type_rank < r.type_rank) return true;
    if (l.type_rank > r.type_rank) return false;

    if (l.fs_rank < r.fs_rank) return true;
    if (l.fs_rank > r.fs_rank) return false;

    if (l.free_bytes.QuadPart < r.free_bytes.QuadPart) return true;
    if (l.free_bytes.QuadPart > r.free_bytes.QuadPart) return false;

    return (l.total_bytes.QuadPart < r.total_bytes.QuadPart);
}

QString get_auto_path()
{
    DWORD drives = GetLogicalDrives();

    std::vector<d_rank> all_ranks;

    for (int i=0;i<32;i++)
    {
        if ( (drives&(1<<i)) == 0 ) continue;

        char diskname[7];
        d_rank  rank;

        rank.letter=diskname[0]='A'+i;
        diskname[1]=':';
        diskname[2]='\\';
        diskname[3]=0;

        // removable
        // 0=net/ram 1=removable 2=fixed
        switch(GetDriveTypeA(diskname))
        {
        case DRIVE_REMOVABLE:
            rank.type_rank=1;
            break;
        case DRIVE_FIXED:
            rank.type_rank=2;
            break;
        case DRIVE_RAMDISK:
        case DRIVE_REMOTE:
            rank.type_rank=0;
            break;
        default:
            rank.type_rank=-1;
            break;
        }
        if (-1==rank.type_rank)
        {
            continue;
        }

        char fs_name[MAX_PATH+1];
        DWORD maxfilelen,fs_flags;

        if (0==GetVolumeInformationA(diskname,NULL,0,NULL,&maxfilelen,&fs_flags,fs_name,MAX_PATH+1)) continue;

        rank.fs_rank=0;

        if (0==strcmp(fs_name,"FAT32")) rank.fs_rank=1;
        if (0==strcmp(fs_name,"VFAT")) rank.fs_rank=1;

        if (0==strcmp(fs_name,"NTFS")) rank.fs_rank=2;

        // free
        if (0==GetDiskFreeSpaceExA(diskname,&rank.free_bytes,&rank.total_bytes,NULL))
        {
            rank.free_bytes.QuadPart=0;
            rank.total_bytes.QuadPart=0;
        }

        all_ranks.push_back(rank);
    }

    std::sort(all_ranks.begin(),all_ranks.end(),rank_compare);

    QString rtn;

    if (all_ranks.empty()) return rtn;

    rtn.reserve(20);
    rtn += QChar::fromLatin1(all_ranks.back().letter);
    rtn += QLatin1String(":/");
    rtn += UI_QSTRING(APP_IFACE_VIDEO_FOLDER_NAME_WIN);

    return rtn;
}

uint64_t get_free_space(const utf16_t* Folder)
{
    ULARGE_INTEGER a1,a2,a3;
    GetDiskFreeSpaceExW((const wchar_t*)Folder,&a1,&a2,&a3);
    return a1.QuadPart;
}
