/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <QtGui/QtGui>
#include "logtext.h"
#include "mainwnd.h"

CLogText* MainWnd::CreateLogText()
{
    return new CLogText();
}

CLogText::CLogText()
{
    setReadOnly(true);
    setLineWrapMode(QTextEdit::NoWrap);
    setTextInteractionFlags(
        Qt::TextSelectableByMouse |
        Qt::TextSelectableByKeyboard | 
        Qt::LinksAccessibleByMouse | 
        Qt::LinksAccessibleByKeyboard );
    viewport()->setMouseTracking(true);
}

bool CLogText::IsAtBottom()
{
    QAbstractSlider* bar = verticalScrollBar();
    int bar_value = bar->value();
    int bar_max = bar->maximum();
    //bool at_end = ( bar_value == bar_max );
    bool at_end = ((bar_max-bar_value) <= (bar_max/20) ); // 5%
    return at_end;
}

void CLogText::ScrollBottom()
{
    QAbstractSlider* bar = verticalScrollBar();
    bar->setValue(bar->maximum());
}


void CLogText::UpdateText(QString text)
{
    QAbstractSlider* bar = verticalScrollBar();
    int bar_value = bar->value();
    bool at_end = IsAtBottom();
    setHtml(text);
    if (at_end)
    {
        bar->setValue(bar->maximum());
    } else {
        bar->setValue(bar_value);
    }
}

bool CLogText::isOverHyperLink(QMouseEvent *e)
{
    static const utf16_t http_str[8]={'h','t','t','p',':','/','/',0};
    QString qstr = anchorAt(e->pos());
    if (qstr.length()==0) return false;
    return qstr.startsWith(QStringFromConstUtf16(http_str));
}

void CLogText::mouseMoveEvent(QMouseEvent *e)
{
    if (isOverHyperLink(e))
    {
        viewport()->setCursor(Qt::PointingHandCursor);
    } else {
        viewport()->setCursor(Qt::ArrowCursor);
    }
    QTextEdit::mouseMoveEvent(e);
}

void CLogText::mousePressEvent(QMouseEvent *e)
{
    if ((e->button()==Qt::LeftButton) && (isOverHyperLink(e)))
    {
        MainWnd* main_window = qobject_cast<MainWnd *>(window());
        if (main_window!=NULL)
        {
            main_window->LaunchUrl(anchorAt(e->pos()));
        }
    }
    QTextEdit::mousePressEvent(e);
}

