/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <QtGui/QApplication>
#include <QtGui/QMessageBox>
#include <lgpl/aproxy.h>

#include "mainwnd.h"

#ifdef Q_OS_WIN
#include <objbase.h>
static void PlatformInitBeforeApp()
{
    CoInitializeEx(NULL,COINIT_APARTMENTTHREADED|COINIT_DISABLE_OLE1DDE);
}
#else
#define PlatformInitBeforeApp()
#endif

int qMain(int argc, char **argv)
{
    PlatformInitBeforeApp();

    static CApClient apc;
    QApplication app(argc, argv);

    if (argc>=3)
    {
        if (strcmp(argv[1],"debug")==0)
        {
            apc.EnableDebug(argv[2]);
        }
    }

#ifdef Q_WS_WIN
    QFont& txt_font = app.font("QMessageBox");
    app.setFont(txt_font,"QLabel");
    app.setFont(txt_font,"QComboBox");
    app.setFont(txt_font,"QTextEdit");
    app.setFont(txt_font,"QLineEdit");
    app.setFont(txt_font,"QDialogButtonBox");
    app.setFont(txt_font,"QAbstractItemView");
    QFont& menu_font = app.font("QMenu");
    app.setFont(menu_font,"QGroupBox");
#endif

    if (false==apc.Init('G',"makemkvcon"))
    {
        QMessageBox::critical(NULL,UI_QSTRING(APP_CAPTION_MSG),UI_QSTRING(APP_INIT_FAILED));
        return 1;
    }

    AppGetInterfaceLanguageData(&apc);

    Q_INIT_RESOURCE(rsrc);

    const char* appdir;
    char* appname = argv[0];
    char *aend = strrchr(appname,'/');
    if (!aend)
    {
        aend = strrchr(appname,'\\');
    }
    if (aend)
    {
        *aend =0;
        appdir = appname;
    } else {
        appdir = ".";
    }

    MainWnd mainWin(&apc,appdir);
    mainWin.show();
    int r = app.exec();

#ifdef Q_WS_MAC
    SemWatchdogStop();
#endif

    return r;
}

extern void __cdecl __stl_debug_message(char const *fmt,...)
{
    va_list lst;
    char tbuf[2000];

    va_start(lst,fmt);
    vsnprintf(tbuf,1999,fmt,lst);
    va_end(lst);
    tbuf[1999]=0;

    QMessageBox::critical(NULL,QLatin1String("STL error"),QLatin1String(tbuf));
}

#if !defined(QT_NEEDS_QMAIN)
extern "C" int main(int argc, char **argv)
{
    return qMain(argc,argv);
}
#endif

