/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#ifndef APP_MAINWND_H
#define APP_MAINWND_H

#include <QtGui/QtGui>
#include <QtCore/QFileInfo>
#include <QtCore/QTime>
#include <lgpl/aproxy.h>
#include "qtapp.h"
#include "dirselectbox.h"

class CLogData;
class CTitleData;
class CLogText;

class CProgressItem
{
    QProgressBar*   m_bar;
    QLabel*         m_label;
    unsigned int    m_value;
    unsigned int    m_lastupdate;
    bool            m_notime;
    QTime           m_pointtime[2];
    int             m_pointbase[2];
    int             m_pointstart[2];
    int             m_pointindex;

public:
    void Init(QProgressBar *bar,QLabel* label);
    void Clear(bool clear_disable_time);
    void Update(unsigned int value,QWidget* update_title);
    void UpdateTime(QWidget* update_title);
    void DisableTime();
};

typedef enum _DiskType
{
    dtUnknown,
    dtDvd,
    dtHdvd,
    dtBluray,
    dtLoading,
    dtMaxValue
} DiskType;

class CDriveInfo
{
public:
    bool            valid;
    bool            show_open;
    QString         name;
    AP_DiskFsFlags  fs_flags;
    DiskType        disk_type;
    QString         type;
    QString         label;
    QString         prot;
    QString         right_info;
public:
    void Update(const utf16_t* DriveName,const utf16_t* DiskName,AP_DiskFsFlags DiskFlags,const void* DiskData,unsigned int DiskDataSize);
    CDriveInfo()
    {
        valid=false;
    }
};

class MainWnd : public QMainWindow , public CApClient::INotifier , public IIconPath
{
    Q_OBJECT

private:
    static  MainWnd* m_myself_static;
    CApClient*  m_app;
    //QString     m_OutputFolder;

public:
    MainWnd(CApClient* App,const char* AppDir);
    ~MainWnd();

private slots:
    void SlotAbout();
    void SlotOpenFiles();
    void SlotOpenTestFile();
    void SlotOnIdle();
    void SlotExiting();
    void SlotOutputFolderEdited();
    void SlotCloseDisk();
    void SlotEjectDisk();
    void SlotSaveAllMkv();
    void SlotStartStreaming();
    void SlotBackup();
    void SlotCancelJob();
    void SlotOpenDrive();
    void SlotOpenDriveBigBtn();
    void SlotTreeSelectionChanged();
    void SlotTreeItemExpanded(QTreeWidgetItem *item);
    void SlotTreeItemCollapsed(QTreeWidgetItem *item);
    void SlotToggleTreeItem();
    void SlotSelectTreeItem();
    void SlotUnselectTreeItem();
    void SlotQuit();
    void SlotSettings();
    void SlotEmptyBoxChanged();
    void SlotHelppage();
    void SlotRegister();
    void SlotPurchase();

private: // app actions
    void EnterJobMode();
    void LeaveJobMode();
    void UpdateDrive(unsigned int Index,const utf16_t *DriveName,bool Visible,bool Enabled,const utf16_t *DiskName,AP_DiskFsFlags DiskFlags,const void* DiskData,unsigned int DiskDataSize);
    void UpdateCurrentBar(unsigned int Value);
    void UpdateTotalBar(unsigned int Value);
    void UpdateLayout(unsigned long CurrentName,unsigned int NameSubindex,unsigned int Flags,unsigned int Size,const unsigned long* Names);
    void UpdateCurrentInfo(unsigned int Index,const utf16_t* Value);
    void SetTotalName(unsigned long Name);
private:
    void DoProcessLogMessage(QString Message,unsigned int Flags);
    int ReportUiMessage(unsigned long Code,unsigned long Flags,const utf16_t* Text);
    void Update_TitleTree_from_app();
    void Update_TitleInfo_from_app();
    void EmptyFrameAddDrive(unsigned int Index,const utf16_t* DriveName,const utf16_t* DiskName,AP_DiskFsFlags FsFlags,const void* DiskData,unsigned int DiskDataSize);
    void EmptyFrameRemoveDrive(unsigned int Index);
    void RefreshEmptyFrame();
    void ResetInfoPane();
    void ExitApp();
    void ClearProgress();
    bool ConfirmCancel();
    int  GetEmptyBoxDriveId();
    void UpdateDrivesCount();
    QString IconPath(const char* iconPath);
public:
    void LaunchUrl(const QString url);

private:
    volatile bool   m_EnteredIdle;
    QFileInfo       m_FileInfo;
    int             m_CurrentlyOpenedDisk;
    bool            m_do_close_disc;
    bool            m_entered_onidle;
    bool            m_job_active;
    bool            m_disc_opened;
    bool            m_do_disc_opened;
    QDialog*        m_cancel_dialog;
    bool            m_have_drives;
    bool            m_disable_onidle;
    bool            m_disable_cancel_dialog;
    bool            m_started;
    bool            m_do_close_app;
    int             m_readstr_count;
    const char*     m_app_dir;
    bool            m_notify_start;
    bool            m_notify_init;
    bool            m_have_last_version;
    int             m_last_version_count;

private:
    void createActions();
    void createIcons();
    void createMenus();
    void createToolBars();
    void createStatusBar();
    void createAllWidgets();
    QWidget* CreateMainFrame();
    QWidget* CreateProgressFrame();
    QWidget* CreateEmptyFrame();
    //QTableView* CreateLogFrame();
    CLogText* CreateLogText();

    QString GetOutputFolderName();
    QString GetOutputBaseName();
    void CalculateDefaultOutputDir();
    void ReReadSettings();
    void ReadStrings();

    // widgets

    QTreeWidget* titleTreeView;
    CTitleData*  titleTreeData;
    QStackedWidget* topStackedWidget;
    QStackedWidget* mainStackedWidget;
    CDirSelectBox* saveFolderBox;
    QLabel* currProgressLabel;
    QLabel* totalProgressLabel;
    QGrayTextViewer* itemInfoEdit;

    QComboBox* emptyDriveBox;
    QToolButton* empty_big_btn;


    CProgressItem   currProgress;
    CProgressItem   totalProgress;
    unsigned long   infoCodes[AP_Progress_MaxLayoutItems];
    QLabel*         infoNames[AP_Progress_MaxLayoutItems];
    QLabel*         infoValues[AP_Progress_MaxLayoutItems];

    CLogText*   logtext_main;
    CLogText*   logtext_progress;
    QString     logtext_text;
    int         logtext_count;

    QLabel*     empty_type;
    QLabel*     empty_label;
    QLabel*     empty_prot;
    QGrayTextViewer*  empty_right_info;

    // menus, etc

    QMenu *fileMenu;
    QMenu *viewMenu;
    QMenu *helpMenu;
    QMenu *drivesMenu;

    QToolBar *mainToolBar;

    QIcon*  mainIcon;
    QIcon*  openFileIcon;
    QIcon*  saveAllIcon;
    QIcon*  settingsIcon;
    QIcon*  ejectIcon;
    QIcon*  cancelIcon;
    QIcon*  infoIcon;
    QIcon*  startStreamingIcon;
    QIcon*  backupIcon;
    QIcon*  bigbtn_icon_dvd;
    QIcon*  bigbtn_icon_hddvd;
    QIcon*  bigbtn_icon_bluray;
    QIcon*  bigbtn_icon_loading;

    QAction *aboutAct;
    QAction *aboutQtAct;
    QAction *settingsAct;
    QAction *ejectAct;
    QAction *quitAct;
    QAction *cancelAct;
    QAction *openFilesAct;
    QAction *openTestFileAct;
//    QAction *setOutputFolderAct;
    QAction *closeDiskAct;
    QAction *saveAllMkvAct;
    QAction *startStreamingAct;
    QAction *backupAct;
    QAction *helppageAct;
public:
    QAction *registerAct;
    QAction *purchaseAct;

private:
    QAction* OpenDriveAction[AP_MaxCdromDevices];
    CDriveInfo DriveInfo[AP_MaxCdromDevices];

    // tree item actions
    QAction *m_tree_toggle;
    QAction *m_tree_select;
    QAction *m_tree_unselect;

    QAction* dvdToHdAct;
    QAction* hddvdToHdAct;
    QAction* blurayToHdAct;
    QAction* loadingDiskAct;

    // settings
    int     setting_DestinationType;
    QString setting_DestinationDir;
    bool    setting_ShowDebug;

public:
    QString app_name;
    QString app_ver;
    QString app_arch;
    QString app_keytype;
    QString app_evalstate;
    QString app_keytime;
    QString app_prgtime;
    QString app_lastver;
};

#endif
