/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <lgpl/aproxy.h>

void CApClient::SignalExit()
{
    ExecCmd(apCallSignalExit);
}

void CApClient::CancelAllJobs()
{
    ExecCmd(apCallCancelAllJobs);
}

void CApClient::OnIdle()
{
    ExecCmd(apCallOnIdle);
}

void CApClient::SetOutputFolder(const utf16_t *Name)
{
    memcpy((void*)m_mem->strbuf,Name,(utf16len(Name)+1)*sizeof(utf16_t));
    ExecCmd(apCallSetOutputFolder);
}

bool CApClient::UpdateAvailableDrives()
{
    ExecCmd(apCallUpdateAvailableDrives);
    return (m_mem->args[0]!=0);
}

bool CApClient::OpenFile(const utf16_t* FileName)
{
    memcpy((void*)m_mem->strbuf,FileName,(utf16len(FileName)+1)*sizeof(utf16_t));
    ExecCmd(apCallOpenFile);
    return (m_mem->args[0]!=0);
}

bool CApClient::OpenTitleCollection(const utf16_t* Source)
{
    memcpy((void*)m_mem->strbuf,Source,(utf16len(Source)+1)*sizeof(utf16_t));
    ExecCmd(apCallOpenTitleCollection);
    return (m_mem->args[0]!=0);
}

bool CApClient::OpenCdDisk(unsigned int Id)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallOpenCdDisk);
    return (m_mem->args[0]!=0);
}

bool CApClient::CloseDisk()
{
    ExecCmd(apCallCloseDisk);
    return (m_mem->args[0]!=0);
}

bool CApClient::EjectDisk(unsigned int Id)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallEjectDisk);
    return (m_mem->args[0]!=0);
}

bool CApClient::SaveAllSelectedTitlesToMkv()
{
    ExecCmd(apCallSaveAllSelectedTitlesToMkv);
    return (m_mem->args[0]!=0);
}

bool CApClient::StartStreaming()
{
    ExecCmd(apCallStartStreaming);
    return (m_mem->args[0]!=0);
}

bool CApClient::BackupDisc(unsigned int Id,const utf16_t* Folder,uint32_t Flags)
{
    m_mem->args[0]=Id;
    m_mem->args[1]=Flags;
    memcpy((void*)m_mem->strbuf,Folder,(utf16len(Folder)+1)*sizeof(utf16_t));
    ExecCmd(apCallBackupDisc);
    return (m_mem->args[0]!=0);
}

bool AP_UiItem::get_Enabled()
{
    if (false==m_stateknown)
    {
        m_client->m_mem->args[0] = m_handle;
        m_client->ExecCmd(apCallGetUiItemState);
        m_state = (m_client->m_mem->args[0]!=0);
        m_stateknown=true;
    }
    return m_state;
}

void AP_UiItem::set_Enabled(bool State)
{
    m_stateknown=true;
    m_state = State;
    m_client->m_mem->args[0] = m_handle;
    m_client->m_mem->args[1] = m_state?1:0;
    m_client->ExecCmd(apCallSetUiItemState);
}

AP_UiItem::AP_UiItem()
{
    memset(m_infos_alloc,0,sizeof(m_infos_alloc));
    Clear();
}

AP_UiItem::AP_UiItem(const AP_UiItem &src)
{
    memset(m_infos_alloc,0,sizeof(m_infos_alloc));
    MoveFrom(&src);
}

AP_UiItem::~AP_UiItem()
{
    Clear();
}

void AP_UiItem::MoveFrom(const AP_UiItem *src)
{
    Clear();
    memcpy(m_infos,src->m_infos,sizeof(m_infos));
    memcpy(m_infos_known,src->m_infos_known,sizeof(m_infos_known));
    memcpy(m_infos_alloc,src->m_infos_alloc,sizeof(m_infos_alloc));

    memset((void*)src->m_infos_alloc,0,sizeof(m_infos_alloc));
}


void AP_UiItem::Clear()
{
    for (unsigned int i=0;i<ap_iaMaxValue;i++)
    {
        if (m_infos_alloc[i]!=0) 
        {
            delete[] m_infos[i];
        }
    }
    memset(m_infos_known,0,sizeof(m_infos_known));
    memset(m_infos_alloc,0,sizeof(m_infos_alloc));
}


const utf16_t* AP_UiItem::GetInfo(AP_ItemAttributeId Id)
{
    if (0!=m_infos_known[Id]) return m_infos[Id];

    m_client->m_mem->args[0]=m_handle;
    m_client->m_mem->args[1]=Id;
    m_client->ExecCmd(apCallGetUiItemInfo);
    m_infos_known[Id]=1;
    if (0!=m_client->m_mem->args[0])
    {
        m_infos[Id]=(utf16_t*)AppGetString((unsigned long)m_client->m_mem->args[0]);
        m_infos_alloc[Id]=0;
    } else {
        if (0==m_client->m_mem->args[1])
        {
            m_infos[Id]=NULL;
            m_infos_alloc[Id]=0;
        } else {
            size_t len = utf16len((utf16_t*)m_client->m_mem->strbuf);
            m_infos[Id]=new utf16_t[len+1];
            memcpy(m_infos[Id],(void*)m_client->m_mem->strbuf,(len+1)*sizeof(utf16_t));
            m_infos_alloc[Id]=1;
        }
    }
   return m_infos[Id];
}

uint64_t AP_UiItem::GetInfoNumeric(AP_ItemAttributeId Id)
{
    const utf16_t* p = GetInfo(Id);
    if (!p) return 0;

    uint64_t v=0;
    while(*p!=0)
    {
        v *= 10;
        v += (*p-'0');
        p++;
    }
    return v;
}

void AP_UiItem::SetInfo(uint64_t handle,CApClient* client)
{
    m_client = client;
    m_handle = handle;
    m_stateknown = false;
    Clear();
}

void CApClient::SetTrackInfo(unsigned int id,unsigned int trkid,uint64_t handle,MkvTrackType type)
{
    m_TitleCollection.m_Titles[id].m_Tracks[trkid].SetInfo(handle,this);
    m_TitleCollection.m_Titles[id].m_Tracks[trkid].m_Type = type;
}

void CApClient::SetTitleInfo(unsigned int id,uint64_t handle,unsigned int Count)
{
    m_TitleCollection.m_Titles[id].SetInfo(handle,this);
    m_TitleCollection.m_Titles[id].m_Tracks.resize(Count);
}

void CApClient::SetTitleCollInfo(uint64_t handle,unsigned int Count)
{
    m_TitleCollection.SetInfo(handle,this);
    m_TitleCollection.m_Titles.resize(Count);
    m_TitleCollection.m_Updated=true;
}

int CApClient::GetSettingInt(ApSettingId Id)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallGetSettingInt);
    return (int)(m_mem->args[0]);
}

const utf16_t* CApClient::GetSettingString(ApSettingId Id)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallGetSettingString);
    if (0==m_mem->args[0]) return NULL;
    return (utf16_t*)(m_mem->strbuf);
}

void CApClient::SetSettingInt(ApSettingId Id,int Value)
{
    m_mem->args[0]=Id;
    m_mem->args[1]=Value;
    ExecCmd(apCallSetSettingInt);
}

void CApClient::SetSettingString(ApSettingId Id,const utf16_t* Value)
{
    m_mem->args[0]=Id;
    if (NULL==Value)
    {
        m_mem->args[1]=0;
    } else {
        m_mem->args[1]=1;
        memcpy((void*)m_mem->strbuf,Value,(utf16len(Value)+1)*sizeof(utf16_t));
    }
    ExecCmd(apCallSetSettingString);
}

bool CApClient::SaveSettings()
{
    ExecCmd(apCallSaveSettings);
    return (m_mem->args[0]!=0);
}

const utf16_t* CApClient::GetAppString(unsigned int Id)
{
    m_mem->args[0] = Id;
    ExecCmd(apCallAppGetString);
    if (m_mem->args[0]==0)
    {
        return NULL;
    } else {
        return (utf16_t*)m_mem->strbuf;
    }
}

bool CApClient::GetInterfaceLanguage(unsigned int Id,utf16_t** Name,uint64_t** Param)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallGetInterfaceLanguage);
    if (m_mem->args[0]==0)
    {
        return false;
    }
    *Name = (utf16_t*)m_mem->strbuf;
    *Param = ((uint64_t*)&(m_mem->args[1]));

    return true;
}

const void* CApClient::GetInterfaceLanguageData(unsigned int Id,unsigned int* Size1,unsigned int* Size2)
{
    m_mem->args[0]=Id;
    ExecCmd(apCallGetInterfaceLanguageData);
    if (m_mem->args[0]==0)
    {
        return false;
    }
    *Size1 = (unsigned int) m_mem->args[0];
    *Size2 = (unsigned int) m_mem->args[1];
    return (void*)m_mem->strbuf;
}

