/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include <QtExt/NativeFileDialog.h>

#if defined(Q_WS_WIN) || defined(Q_WS_MAC)
#include <QtGui/private/qfiledialog_p.h>
#endif

/*
    For the native file dialogs
*/

#if defined(Q_WS_WIN)
extern QString qt_win_get_open_file_name(const QFileDialogArgs &args,
                                         QString *initialDirectory,
                                         QString *selectedFilter);

extern QString qt_win_get_save_file_name(const QFileDialogArgs &args,
                                         QString *initialDirectory,
                                         QString *selectedFilter);

extern QStringList qt_win_get_open_file_names(const QFileDialogArgs &args,
                                              QString *initialDirectory,
                                              QString *selectedFilter);

extern QString qt_win_get_existing_directory(const QFileDialogArgs &args);

#elif defined(Q_WS_MAC)
extern QStringList qt_mac_get_open_file_names(const QFileDialogArgs &args,
                                              QString *pwd,
                                              QString *selectedFilter);

extern QString qt_mac_get_save_file_name(const QFileDialogArgs &args,
                                         QString *pwd,
                                         QString *selectedFilter);
#endif


static QString QFDP_workingDirectory(const QString &path)
{
    if (!path.isEmpty()) {
        QFileInfo info(path);
        if (info.exists() && info.isDir())
            return info.absoluteFilePath();
        return info.absolutePath();
    }
    return QDir::currentPath();
}

static QString QFDP_initialSelection(const QString &path)
{
    if (!path.isEmpty()) {
        QFileInfo info(path);
        if (!info.isDir())
            return info.fileName();
    }
    return QString();
}



QString QNativeFileDialog::getExistingDirectory(QWidget *parent,
                                    const QString &caption,
                                    const QString &dir,
                                    QFileDialog::Options options)
{
    Q_ASSERT( !(options & QFileDialog::DontUseNativeDialog) );

#if defined(Q_WS_WIN) || defined(Q_WS_MAC)
    QFileDialogArgs args;
    args.parent = parent;
    args.caption = caption;
    args.directory = QFDP_workingDirectory(dir);
    args.mode = (options & QFileDialog::ShowDirsOnly ? QFileDialog::DirectoryOnly : QFileDialog::Directory);
    args.options = options;
#endif

#if defined(Q_WS_WIN)
    Q_ASSERT( (options & QFileDialog::ShowDirsOnly) );
    return qt_win_get_existing_directory(args);
#elif defined(Q_WS_MAC)
    Q_ASSERT( !(args.options & QFileDialog::DontUseNativeDialog) );
    QStringList files = qt_mac_get_open_file_names(args, 0, 0);
    if (!files.isEmpty())
        return files.first().normalized(QString::NormalizationForm_C);
    return QString();
#else
    return QFileDialog::getExistingDirectory(parent,caption,dir,options);
#endif
}

QString QNativeFileDialog::getOpenFileName(QWidget *parent,
                               const QString &caption,
                               const QString &dir,
                               const QString &filter,
                               QString *selectedFilter,
                               QFileDialog::Options options)
{
    Q_ASSERT( !(options & QFileDialog::DontUseNativeDialog) );

#if defined(Q_WS_WIN) || defined(Q_WS_MAC)
    QFileDialogArgs args;
    args.parent = parent;
    args.caption = caption;
    args.directory = QFDP_workingDirectory(dir);
    args.selection = QFDP_initialSelection(dir);
    args.filter = filter;
    args.mode = QFileDialog::ExistingFile;
    args.options = options;
#endif
    
#if defined(Q_WS_WIN)
    if (dir.isEmpty()) {
        args.options |= QFileDialog::WinUseAutoLastFolder;
        args.directory = QString();
    }
    return qt_win_get_open_file_name(args, &(args.directory), selectedFilter);
#elif defined(Q_WS_MAC)
    QStringList files = qt_mac_get_open_file_names(args, &(args.directory), selectedFilter);
    if (!files.isEmpty())
        return files.first().normalized(QString::NormalizationForm_C);
    return QString();
#else
    return QFileDialog::getOpenFileName(parent,caption,dir,filter,selectedFilter,options);
#endif
}

