/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include "qtapp.h"
#include "notify.h"
#include <windows.h>
#include <shobjidl.h>

//MIDL_INTERFACE("ea1afb91-9e28-4b86-90e9-9e9f8a5eefaf")
class ITaskbarList3Lite : public ITaskbarList2
{
public:
    virtual HRESULT STDMETHODCALLTYPE SetProgressValue( 
        /* [in] */ HWND hwnd,
        /* [in] */ ULONGLONG ullCompleted,
        /* [in] */ ULONGLONG ullTotal) = 0;

    virtual HRESULT STDMETHODCALLTYPE SetProgressState( 
        /* [in] */ HWND hwnd,
        /* [in] */ ULONG tbpFlags) = 0;
};


static ITaskbarList3Lite* ptl = NULL;

void notifyInit()
{
    static const UCHAR iidtl3[16]={0x91,0xfb,0x1a,0xea,0x28,0x9e,0x86,0x4b,0x90,0xe9,0x9e,0x9f,0x8a,0x5e,0xef,0xaf};
    if (CoCreateInstance(CLSID_TaskbarList, NULL, CLSCTX_ALL, *(UUID*)iidtl3, (void**)&ptl)!=S_OK)
    {
        ptl = NULL;
    }
}

void notifyStart(QMainWindow* mainWindow,unsigned long Id,const QString &Name)
{
    if (ptl)
    {
        ptl->SetProgressState(mainWindow->winId(),2);
    }
}

void notifyUpdate(QMainWindow* mainWindow,unsigned int Value,unsigned int MaxValue)
{
    if (ptl)
    {
        ptl->SetProgressValue(mainWindow->winId(),Value,MaxValue);
    }
}

void notifyEvent(QMainWindow* mainWindow,unsigned long Id,const char* Name,const QString &Text)
{
}

void notifyFinish(QMainWindow* mainWindow)
{
    if (ptl)
    {
        ptl->SetProgressState(mainWindow->winId(),0);
    }
}

void notifyCleanup()
{
    if (ptl)
    {
        ptl->Release();
        ptl = NULL;
    }
}


