/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#ifndef APP_QTAPP_H
#define APP_QTAPP_H

#include <QtGui/QtGui>
#include <lgpl/aproxy.h>

#define QT_C_ASSERT(e) typedef char __QT_C_ASSERT__[(e)?1:-1]

#include "qtstr.h"

class QSimpleLabel : public QLabel
{
public:
    QSimpleLabel() : QLabel()
    {
        setTextFormat(Qt::PlainText);
        setWordWrap(false);
    }
};

class QGrayTextViewer : public QTextEdit
{
public:
    QGrayTextViewer()
    {
        /*
        QPalette p=palette();
        p.setColor(QPalette::Active, QPalette::Base , p.window().color() );
        setPalette(p);
        */
        setReadOnly(true);
        setLineWrapMode(QTextEdit::NoWrap);
    }
    void setHtmlBody(const QString& str);
};

static inline QLabel* createLabel(const QString &txt)
{
    QLabel* t = new QSimpleLabel();
    t->setText(txt);
    return t;
}

static inline QFrame* createHLine()
{
    QFrame *hline = new QFrame();
    hline->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    return hline;
}

void AppendGrayBodyTag(QString &str,const QWidget *widget);

QString FormatDiskFreeSpace(const utf16_t* FolderName);
bool FormatDriveDiskInfo(QString& ProtectionString,QString& FullInfoString,const void* DiskData,unsigned int DiskDataSize,AP_DiskFsFlags FsFlags);
void ApplyDefaultSelection(AP_UiTitleCollection *Coll,const utf16_t* PreferredLanguage);

class IIconPath
{
public:
    virtual QString IconPath(const char* iconPath)=0;
};

#endif // APP_QTAPP_H
