/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#ifndef APP_QTSTR_H
#define APP_QTSTR_H

QT_C_ASSERT(sizeof(ushort)==sizeof(utf16_t));
QT_C_ASSERT(sizeof(ushort)==sizeof(QChar));

static inline const utf16_t* Utf16FromQString(const QString &str)
{
    return (const utf16_t*)str.utf16();
}

static inline QString QStringFromUtf16(const utf16_t *str)
{
    QString t;
    if (NULL!=str)
    {
        t.setUtf16((const ushort*)str,utf16len(str));
    }
    return t;
}

static inline utf16_t* QStringAccessBufferRW(QString &str)
{
    QChar* p = str.data();
    return (utf16_t*)p;
}

static inline void QStringFixLen(QString &str)
{
    const QChar* p = str.constData();
    str.truncate((int)utf16len((const utf16_t*)p));
}

static inline QString QStringFromConstUtf16(const utf16_t *str)
{
    int size = (int) utf16len(str);
    return QString::fromRawData( (QChar*) str , size );
}

#define UI_QSTRING(msg) \
    QStringFromConstUtf16( AP_UI_STRING(msg) )


static inline void append_const(QString &Qstr,const char *Str,size_t Size)
{
    for (size_t i=0;i<Size;i++)
    {
        if (Str[i]==0)
        {
            Size=i;
            break;
        }
    }
    if (0==Size) return;

    unsigned int old_size = Qstr.size();
    unsigned int have = ( Qstr.capacity() - old_size );
    if (have >= ((unsigned int)(Size+1)))
    {
        Qstr.resize(old_size+Size);
        utf16_t* buf = QStringAccessBufferRW(Qstr) + old_size;
        for (size_t i=0;i<Size;i++)
        {
            buf[i] = Str[i];
        }
    } else {
        Qstr.append(QLatin1String(QByteArray::fromRawData(Str,Size)));
    }
}

static inline void append_const(QString &Qstr,const char *Str)
{
    size_t sz = strlen(Str);
    append_const(Qstr,Str,sz);
}

static inline void append_const(QString &Qstr,const utf16_t *Str)
{
    Qstr.append(QStringFromConstUtf16(Str));
}



#endif // APP_QTSTR_H

