/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include "qtapp.h"

class SemWatchdogThread : public QThread
{
    bool volatile       fired;
    bool volatile       armed;
    bool volatile       stop;
    uint32_t volatile   tick;
    uint32_t volatile   alarm;
    AP_SGRP*    sem_sgrp;
    uintptr_t   sem_sid;
public:
    SemWatchdogThread(AP_SGRP *sgrp,uintptr_t sid);
    void run();
    void SignalStop();
    void Arm(bool Enable);
    bool Fired();
};

SemWatchdogThread::SemWatchdogThread(AP_SGRP *sgrp,uintptr_t sid)
{
    sem_sgrp = sgrp;
    sem_sid = sid;
    fired = false;
    armed = false;
    stop = false;
    tick = 0;
    start(QThread::TimeCriticalPriority);
}

void SemWatchdogThread::run()
{
    while(stop==false)
    {
        msleep(10);
        tick++;
        if (armed && (tick>alarm))
        {
            fired=true;
            armed=false;
            stop=true;
            ApSemInc(sem_sgrp,sem_sid);
        }
    }
}

void SemWatchdogThread::SignalStop()
{
    stop=true;
}

void SemWatchdogThread::Arm(bool Enable)
{
    armed = false;
    if (Enable)
    {
        alarm = tick + ((AP_SEM_TIMEOUT*100)+10);
        armed = true;
    }
}

bool SemWatchdogThread::Fired()
{
    return fired;
}

static SemWatchdogThread*  watchdogThread = NULL;

bool SemWatchdogStart(AP_SGRP *sgrp,uintptr_t sid)
{
    watchdogThread = new SemWatchdogThread(sgrp,sid);
    return true;
}

void SemWatchdogStop()
{
    if (NULL!=watchdogThread)
    {
        watchdogThread->SignalStop();
    }
}

void SemWatchdogArm(bool Enable)
{
    if (NULL!=watchdogThread)
    {
        watchdogThread->Arm(Enable);
    }
}

bool SemWatchdogFired()
{
    if (NULL!=watchdogThread)
    {
        return watchdogThread->Fired();
    }
    return false;
}
