/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#ifndef APP_SETTINGDLG_H
#define APP_SETTINGDLG_H

#include <QtGui/QtGui>
#include <lgpl/aproxy.h>
#include "dirselectbox.h"

class CGeneralTab : public QWidget
{
    Q_OBJECT

public:
    CDirSelectBox*   destinationDir;
    QRadioButton*   radio_None;
    QRadioButton*   radio_Auto;
    QRadioButton*   radio_SemiAuto;
    QRadioButton*   radio_Custom;

    QCheckBox*      check_DebugLog;
    QCheckBox*      check_SiteAccess;

public:
    CGeneralTab(IIconPath* iconPath,QWidget *parent = 0);
private slots:
    void SlotIndexChanged();
}; 

class CLanguageTab : public QWidget
{
    Q_OBJECT

public:
    QComboBox*  comboBoxInterfaceLanguage;
    QComboBox*  comboBoxPreferredLanguage;

public:
    CLanguageTab(CApClient* ap_client,QWidget *parent = 0);
    static void setValue(QComboBox*  comboBox,const utf16_t *value);
    static const utf16_t* getValue(QComboBox*  comboBox,QString &buffer);
}; 


class CIOTab : public QWidget
{
    Q_OBJECT

public:
    QSpinBox*   spinBoxRetryCount;
    QComboBox*  comboBoxRBufSize;
    QCheckBox*  checkNoDirectIo;
    QComboBox*  comboBoxDarwinK2Workaround;

public:
    CIOTab(QWidget *parent = 0);
}; 

class CDVDTab : public QWidget
{
    Q_OBJECT

public:
    QSpinBox*    spinBoxMinimumTitleLength;
    QComboBox*   comboBoxSpRemoveMethod;


public:
    CDVDTab(QWidget *parent = 0);
}; 

class CAACSTab : public QWidget
{
    Q_OBJECT

public:
    CDirSelectBox*  keyDir;

public:
    CAACSTab(IIconPath* iconPath,QWidget *parent = 0);
}; 

class CBDPTab : public QWidget
{
    Q_OBJECT

public:
    CDirSelectBox*  svqDir;
    CDirSelectBox*  dumpDir;
    QCheckBox*      check_DumpAlways;

public:
    CBDPTab(IIconPath* iconPath,QWidget *parent = 0);
}; 

class CStreamTab : public QWidget
{
    Q_OBJECT

public:
    QCheckBox*      checkEnableUpnp;
    QComboBox*      comboAddress;
    QSpinBox*       spinPort;

public:
    CStreamTab(QWidget *parent = 0);
}; 

class CSettingDialog : public QDialog
{
    Q_OBJECT

public:
    CSettingDialog(CApClient* ap_client,IIconPath* iconPath,QIcon* icon,QWidget *parent = 0);

private:
    CApClient* client;
    QTabWidget *tabWidget;
    QDialogButtonBox *buttonBox;
    bool    show_restart_box;

public: // tabs
    CGeneralTab* generalTab;
    CLanguageTab* languageTab;
    CIOTab* ioTab;
    CDVDTab* dvdTab;
    CAACSTab* aacsTab;
    CBDPTab* bdpTab;
    CStreamTab* streamTab;

private slots:
    void SlotApply();
public:
    void ReadSettings();
    bool WriteSettings();
};


#endif // APP_SETTINGDLG_H
