/*
    MakeMKV GUI - Graphics user interface application for MakeMKV

    Copyright (C) 2009-2010 GuinpinSoft inc <makemkvgui@makemkv.com>

    The contents of this file are subject to the Mozilla Public License
    Version 1.1 (the "License"); you may not use this file except in
    compliance with the License. You may obtain a copy of the License at
    http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS IS"
    basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
    License for the specific language governing rights and limitations
    under the License.

*/
#include "qtapp.h"

static void TempAddAllAttributes(AP_UiItem *pi,QStringList &lst)
{
    for (unsigned int id=ap_iaUnknown+1;id<ap_iaMaxValue;id++)
    {
        const utf16_t* p;

        p = pi->GetInfo( (AP_ItemAttributeId) id );
        if (NULL!=p)
        {
            QString t;
            t = QString::number(id);
            t.append(QLatin1String(":"));
            t += QStringFromConstUtf16(p);

            lst += t;
        }
    }
}

static void AppendCommonAttributes(QString &str,AP_UiItem *pi)
{
    const utf16_t* p;
    unsigned int flags;

    if (NULL!=(p=pi->GetInfo(ap_iaType)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_TYPE));
        append_const(str,p);
        append_const(str,"<br>");
    }
    flags =pi->GetInfoNumeric(ap_iaStreamFlags);
    if ((flags&(AP_AVStreamFlag_DirectorsComments|
        AP_AVStreamFlag_AlternateDirectorsComments|
        AP_AVStreamFlag_ForVisuallyImpaired|
        AP_AVStreamFlag_SecondaryAudio|
        AP_AVStreamFlag_CoreAudio|
        AP_AVStreamFlag_ForcedSubtitles))!=0)
    {
        bool first = true;
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_FLAGS));
        if ((flags&AP_AVStreamFlag_DirectorsComments)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_DIRECTORS_COMMENTS));
        }
        if ((flags&AP_AVStreamFlag_AlternateDirectorsComments)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_ALT_DIRECTORS_COMMENTS));
        }
        if ((flags&AP_AVStreamFlag_ForVisuallyImpaired)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_FOR_VISUALLY_IMPAIRED));
        }
        if ((flags&AP_AVStreamFlag_CoreAudio)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_CORE_AUDIO));
        }
        if ((flags&AP_AVStreamFlag_SecondaryAudio)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_SECONDARY_AUDIO));
        }
        if ((flags&AP_AVStreamFlag_ForcedSubtitles)!=0)
        {
            if (false==first) append_const(str,",");
            first=false;
            append_const(str,AP_UI_STRING(APP_IFACE_FLAGS_FORCED_SUBTITLES));
        }
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaDateTime)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_TIMESTAMP));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaName)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_NAME));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaSourceFileName)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_SRCNAME));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaAngleInfo)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_ANGLE));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaLangName)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_LANGUAGE));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaDuration)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_DURATION));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaChapterCount)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_CHAPTERS));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaCodecLong)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_CODEC));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaAudioChannelsCount)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_CHANNELS));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaAudioSampleRate)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_SAMPLERATE));
        append_const(str,p);
        append_const(str," kHz<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaAudioSampleSize)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_SAMPLEBITS));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaVideoSize)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_RESOLUTION));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaVideoAspectRatio)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_ASPECT));
        append_const(str,p);
        append_const(str,"<br>");
    }
    if (NULL!=(p=pi->GetInfo(ap_iaVideoFrameRate)))
    {
        append_const(str,AP_UI_STRING(APP_IFACE_ITEMLINE_FRAMERATE));
        append_const(str,p);
        append_const(str,"<br>");
    }
}

static const unsigned int TypicalInfoSize = 512;

QString BuildCollectionItemInfo(AP_UiTitleCollection *Coll)
{
    QString str;
    str.reserve(TypicalInfoSize);

    append_const(str,AP_UI_STRING(APP_IFACE_ITEMINFO_SOURCE));

    AppendCommonAttributes(str,Coll);

    if (str.size()>=TypicalInfoSize)
    {
        qDebug("collection info string reallocated, size=%u",((unsigned int)str.size()));
    }
    str.squeeze();
    return str;
}


QString BuildTitleItemInfo(AP_UiTitle *Title)
{
    QString str;
    str.reserve(TypicalInfoSize);

    append_const(str,AP_UI_STRING(APP_IFACE_ITEMINFO_TITLE));

    AppendCommonAttributes(str,Title);

    if (str.size()>=TypicalInfoSize)
    {
        qDebug("title info string reallocated, size=%u",((unsigned int)str.size()));
    }
    str.squeeze();
    return str;
}

QString BuildTrackItemInfo(AP_UiTrack *Track)
{
    QString str;
    str.reserve(TypicalInfoSize);

    append_const(str,AP_UI_STRING(APP_IFACE_ITEMINFO_TRACK));

    AppendCommonAttributes(str,Track);

    if (str.size()>=TypicalInfoSize)
    {
        qDebug("track info string reallocated, size=%u",((unsigned int)str.size()));
    }
    str.squeeze();
    return str;
}

