// license:BSD-3-Clause
// copyright-holders:smf
#pragma once

#ifndef __ZNMCU_H__
#define __ZNMCU_H__

#include "emu.h"

extern const device_type ZNMCU;

#define MCFG_ZNMCU_DATAOUT_HANDLER(_devcb) \
	devcb = &znmcu_device::set_dataout_handler(*device, DEVCB_##_devcb);

#define MCFG_ZNMCU_DSR_HANDLER(_devcb) \
	devcb = &znmcu_device::set_dsr_handler(*device, DEVCB_##_devcb);

#define MCFG_ZNMCU_DSW_HANDLER(_devcb) \
	devcb = &znmcu_device::set_dsw_handler(*device, DEVCB_##_devcb);

#define MCFG_ZNMCU_ANALOG1_HANDLER(_devcb) \
	devcb = &znmcu_device::set_analog1_handler(*device, DEVCB_##_devcb);

#define MCFG_ZNMCU_ANALOG2_HANDLER(_devcb) \
	devcb = &znmcu_device::set_analog2_handler(*device, DEVCB_##_devcb);

class znmcu_device : public device_t
{
public:
	znmcu_device(const machine_config &mconfig, const char *tag, device_t *owner, uint32_t clock);

	// static configuration helpers
	template<class _Object> static devcb_base &set_dsw_handler(device_t &device, _Object object) { return downcast<znmcu_device &>(device).m_dsw_handler.set_callback(object); }
	template<class _Object> static devcb_base &set_analog1_handler(device_t &device, _Object object) { return downcast<znmcu_device &>(device).m_analog1_handler.set_callback(object); }
	template<class _Object> static devcb_base &set_analog2_handler(device_t &device, _Object object) { return downcast<znmcu_device &>(device).m_analog2_handler.set_callback(object); }
	template<class _Object> static devcb_base &set_dataout_handler(device_t &device, _Object object) { return downcast<znmcu_device &>(device).m_dataout_handler.set_callback(object); }
	template<class _Object> static devcb_base &set_dsr_handler(device_t &device, _Object object) { return downcast<znmcu_device &>(device).m_dsr_handler.set_callback(object); }

	WRITE_LINE_MEMBER(write_select);
	WRITE_LINE_MEMBER(write_clock);

protected:
	// device-level overrides
	virtual void device_start() override;
	virtual void device_timer(emu_timer &timer, device_timer_id id, int param, void *ptr) override;

private:
	devcb_read8 m_dsw_handler;
	devcb_read8 m_analog1_handler;
	devcb_read8 m_analog2_handler;
	devcb_write_line m_dataout_handler;
	devcb_write_line m_dsr_handler;

	static const int MaxBytes = 3;
	int m_select;
	int m_clk;
	int m_bit;
	int m_byte;
	int m_databytes;
	uint8_t m_send[MaxBytes];
	emu_timer *m_mcu_timer;
};

#endif
