// license:BSD-3-Clause
// copyright-holders:Olivier Galibert, Miodrag Milanovic

/* Williams WPC Fliptronics II */

#include "emu.h"
#include "includes/wpc_flip2.h"
#include "screen.h"
#include "speaker.h"


static ADDRESS_MAP_START( wpc_flip2_map, AS_PROGRAM, 8, wpc_flip2_state )
	AM_RANGE(0x0000, 0x2fff) AM_READWRITE(ram_r,ram_w)
	AM_RANGE(0x3000, 0x31ff) AM_RAMBANK("dmdbank1")
	AM_RANGE(0x3200, 0x33ff) AM_RAMBANK("dmdbank2")
	AM_RANGE(0x3400, 0x35ff) AM_RAMBANK("dmdbank3")
	AM_RANGE(0x3600, 0x37ff) AM_RAMBANK("dmdbank4")
	AM_RANGE(0x3800, 0x39ff) AM_RAMBANK("dmdbank5")
	AM_RANGE(0x3a00, 0x3bff) AM_RAMBANK("dmdbank6")
	AM_RANGE(0x3c00, 0x3faf) AM_RAM
	AM_RANGE(0x3fb0, 0x3fff) AM_DEVREADWRITE("wpc",wpc_device,read,write) // WPC device
	AM_RANGE(0x4000, 0x7fff) AM_ROMBANK("cpubank")
	AM_RANGE(0x8000, 0xffff) AM_ROMBANK("fixedbank")
ADDRESS_MAP_END

static INPUT_PORTS_START( wpc_flip2 )
	PORT_START("INP0")
	PORT_BIT( 0xff, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START("INP1")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_SLASH_PAD)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_ASTERISK)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_START )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_7_PAD)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_8_PAD)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_9_PAD)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER )  PORT_CODE(KEYCODE_5_PAD)

	PORT_START("INP2")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_A)  // slam tilt
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_S) PORT_TOGGLE  // coin door closed
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_D)
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_OTHER )  // always closed
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_G)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_H)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_J)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_K)

	PORT_START("INP4")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_L)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_Z)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_C)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_V)
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_B)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_N)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_M)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_COMMA)

	PORT_START("INP8")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_STOP)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_SLASH)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_COLON)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_QUOTE)
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_X)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_MINUS)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_EQUALS)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_BACKSPACE)

	PORT_START("INP10")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_OPENBRACE)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_CLOSEBRACE)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_BACKSLASH)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_ENTER)
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_LEFT)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_RIGHT)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_UP)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_DOWN)

	PORT_START("INP20")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_Q)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_W)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_E)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_R)
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_Y)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_U)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_I)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_O)

	PORT_START("INP40")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_LALT)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_0_PAD)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_1_PAD)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_2_PAD)
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_3_PAD)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_4_PAD)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_OTHER ) PORT_CODE(KEYCODE_6_PAD)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START("INP80")
	PORT_BIT( 0xff, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START("COIN")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_COIN4 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_SERVICE ) PORT_NAME("Service / Escape") PORT_CODE(KEYCODE_DEL_PAD)
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_VOLUME_DOWN ) PORT_CODE(KEYCODE_MINUS_PAD)
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_VOLUME_UP ) PORT_CODE(KEYCODE_PLUS_PAD)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_OTHER ) PORT_NAME("Begin Test / Enter") PORT_CODE(KEYCODE_ENTER_PAD)

	PORT_START("FLIP")
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Right Flipper EOS") PORT_CODE(KEYCODE_RSHIFT)
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Right Flipper Button") PORT_CODE(KEYCODE_RSHIFT)
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Left Flipper EOS") PORT_CODE(KEYCODE_LSHIFT)
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Left Flipper Button") PORT_CODE(KEYCODE_LSHIFT)
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Upper Right Flipper EOS") PORT_CODE(KEYCODE_RSHIFT)
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Upper Right Flipper Button") PORT_CODE(KEYCODE_RSHIFT)
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Upper Left Flipper EOS") PORT_CODE(KEYCODE_LSHIFT)
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_NAME("Upper Left Flipper Button") PORT_CODE(KEYCODE_LSHIFT)

	PORT_START("DIPS")
	PORT_DIPNAME(0x01,0x01,"Switch 1") PORT_DIPLOCATION("SWA:1")
	PORT_DIPSETTING(0x00,DEF_STR( Off ))
	PORT_DIPSETTING(0x01,DEF_STR( On ))
	PORT_DIPNAME(0x02,0x02,"Switch 2") PORT_DIPLOCATION("SWA:2")
	PORT_DIPSETTING(0x00,DEF_STR( Off ))
	PORT_DIPSETTING(0x02,DEF_STR( On ))
	PORT_DIPNAME(0x04,0x00,"W20") PORT_DIPLOCATION("SWA:3")
	PORT_DIPSETTING(0x00,DEF_STR( Off ))
	PORT_DIPSETTING(0x04,DEF_STR( On ))
	PORT_DIPNAME(0x08,0x00,"W19") PORT_DIPLOCATION("SWA:4")
	PORT_DIPSETTING(0x00,DEF_STR( Off ))
	PORT_DIPSETTING(0x08,DEF_STR( On ))
	PORT_DIPNAME(0xf0,0x00,"Country") PORT_DIPLOCATION("SWA:5,6,7,8")
	PORT_DIPSETTING(0x00,"USA 1")
	PORT_DIPSETTING(0x10,"France 1")
	PORT_DIPSETTING(0x20,"Germany")
	PORT_DIPSETTING(0x30,"France 2")
	PORT_DIPSETTING(0x40,"Unknown 1")
	PORT_DIPSETTING(0x50,"Unknown 2")
	PORT_DIPSETTING(0x60,"Unknown 3")
	PORT_DIPSETTING(0x70,"Unknown 4")
	PORT_DIPSETTING(0x80,"Export 1")
	PORT_DIPSETTING(0x90,"France 3")
	PORT_DIPSETTING(0xa0,"Export 2")
	PORT_DIPSETTING(0xb0,"France 4")
	PORT_DIPSETTING(0xc0,"UK")
	PORT_DIPSETTING(0xd0,"Europe")
	PORT_DIPSETTING(0xe0,"Spain")
	PORT_DIPSETTING(0xf0,"USA 2")
INPUT_PORTS_END

INPUT_PORTS_START( wpc_dw )
	PORT_INCLUDE( wpc_flip2 )

	PORT_MODIFY("INP2")
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_G)
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_H)
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_J)

	PORT_MODIFY("INP4")
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_Z)
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_C)

	PORT_MODIFY("INP10")
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_UP)  // trap door down

	PORT_MODIFY("INP40")
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_LALT)
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_0_PAD)
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_1_PAD)
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_2_PAD)
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_3_PAD)
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_4_PAD)
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_OTHER ) PORT_CODE(KEYCODE_6_PAD)
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_MODIFY("INP80")
	PORT_BIT( 0xfd, IP_ACTIVE_LOW, IPT_UNKNOWN )  // playfield glass - so we don't annoyed by constant warnings about it.
INPUT_PORTS_END

DRIVER_INIT_MEMBER(wpc_flip2_state,wpc_flip2)
{
	wpc_flip1_state::init_wpc_flip1();
}

static MACHINE_CONFIG_START( wpc_flip2, wpc_flip2_state )
	/* basic machine hardware */
	MCFG_CPU_ADD("maincpu", M6809, 2000000)
	MCFG_CPU_PROGRAM_MAP(wpc_flip2_map)

	MCFG_WMS_WPC_ADD("wpc")
	MCFG_WPC_IRQ_ACKNOWLEDGE(WRITELINE(wpc_dot_state,wpc_irq_w))
	MCFG_WPC_FIRQ_ACKNOWLEDGE(WRITELINE(wpc_dot_state,wpc_firq_w))
	MCFG_WPC_ROMBANK(WRITE8(wpc_dot_state,wpc_rombank_w))
	MCFG_WPC_SOUND_CTRL(READ8(wpc_dot_state,wpc_sound_ctrl_r),WRITE8(wpc_dot_state,wpc_sound_ctrl_w))
	MCFG_WPC_SOUND_DATA(READ8(wpc_dot_state,wpc_sound_data_r),WRITE8(wpc_dot_state,wpc_sound_data_w))
	MCFG_WPC_DMDBANK(WRITE8(wpc_dot_state,wpc_dmdbank_w))

	MCFG_SPEAKER_STANDARD_MONO("speaker")
	MCFG_SOUND_ADD("wpcsnd", WPCSND, 0)
	MCFG_WPC_ROM_REGION(":sound1")
	MCFG_WPC_SOUND_REPLY_CALLBACK(WRITELINE(wpc_dot_state,wpcsnd_reply_w))
	MCFG_SOUND_ROUTE(ALL_OUTPUTS, "speaker", 1.0)

	MCFG_DEFAULT_LAYOUT(layout_lcd)

	MCFG_SCREEN_ADD("screen", RASTER)
	MCFG_SCREEN_SIZE(128, 32)
	MCFG_SCREEN_VISIBLE_AREA(0, 128-1, 0, 32-1)
	MCFG_SCREEN_REFRESH_RATE(60)
	MCFG_SCREEN_UPDATE_DRIVER(wpc_dot_state, screen_update)
MACHINE_CONFIG_END

/*-----------------
/  Black Rose #20013
/------------------*/
ROM_START(br_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("brose_l4.rom", 0x00000, 0x80000, CRC(e140dc46) SHA1(a64dd212dadac17c3424cd0a8ae617f55736c22d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("br_u14.l1", 0x000000, 0x40000, CRC(490bb87f) SHA1(2e4c0bf776b82e2b5fb60c651edd34ab65d6c5aa))
	ROM_RELOAD( 0x000000 + 0x40000, 0x40000)
	ROM_LOAD("br_u15.l1", 0x080000, 0x20000, CRC(10250e96) SHA1(769c9a8c7e2bf4af312345d885afa000c4aedf3d))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("br_u18.l1", 0x100000, 0x20000, CRC(7d446e7d) SHA1(2b03235aecbea0f6f5efad5aff9da194b0981130))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(br_p17)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x40000, "code", 0)
	ROM_LOAD("u6-p17.rom", 0x00000, 0x40000, CRC(c5629f68) SHA1(580b38d57c4297525c5a96719fb886b2b6cfa772))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("br_u14.l1", 0x000000, 0x40000, CRC(490bb87f) SHA1(2e4c0bf776b82e2b5fb60c651edd34ab65d6c5aa))
	ROM_RELOAD( 0x000000 + 0x40000, 0x40000)
	ROM_LOAD("br_u15.l1", 0x080000, 0x20000, CRC(10250e96) SHA1(769c9a8c7e2bf4af312345d885afa000c4aedf3d))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("u18-sp1.rom", 0x100000, 0x20000, CRC(01fb319d) SHA1(881180fbf524823cc3a89efe6dd6a444b40552ee))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(br_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-l1.rom", 0x00000, 0x80000, CRC(87ad7f78) SHA1(5978fb753574bfbfcf5164bc098c5764df8c7403))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("br_u14.l1", 0x000000, 0x40000, CRC(490bb87f) SHA1(2e4c0bf776b82e2b5fb60c651edd34ab65d6c5aa))
	ROM_RELOAD( 0x000000 + 0x40000, 0x40000)
	ROM_LOAD("br_u15.l1", 0x080000, 0x20000, CRC(10250e96) SHA1(769c9a8c7e2bf4af312345d885afa000c4aedf3d))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("br_u18.l1", 0x100000, 0x20000, CRC(7d446e7d) SHA1(2b03235aecbea0f6f5efad5aff9da194b0981130))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(br_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-l3.rom", 0x00000, 0x80000, CRC(d9a47ca7) SHA1(1ef407d06a9bda1f1273289273283b9bd31001c8))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("br_u14.l1", 0x000000, 0x40000, CRC(490bb87f) SHA1(2e4c0bf776b82e2b5fb60c651edd34ab65d6c5aa))
	ROM_RELOAD( 0x000000 + 0x40000, 0x40000)
	ROM_LOAD("br_u15.l1", 0x080000, 0x20000, CRC(10250e96) SHA1(769c9a8c7e2bf4af312345d885afa000c4aedf3d))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("br_u18.l1", 0x100000, 0x20000, CRC(7d446e7d) SHA1(2b03235aecbea0f6f5efad5aff9da194b0981130))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

/*-----------------
/  Bram Stoker's Dracula #50001
/------------------*/
ROM_START(drac_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("dracu_l1.rom", 0x00000, 0x80000, CRC(b8679686) SHA1(fdd25368f6134523ff3d68df9399a99784a00b7d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("dracsnd.u14", 0x000000, 0x80000, CRC(5137aaf5) SHA1(e6ee924e7e4718db0f7f315f2a6843e6f90afb41))
	ROM_LOAD("dracsnd.u15", 0x080000, 0x80000, CRC(77b5abe2) SHA1(e5622ae9ae0c1a0be886a1e5dc25b5a42c00c2ae))
	ROM_LOAD("dracsnd.u18", 0x100000, 0x80000, CRC(372ffb90) SHA1(89979670869c565d3ab86abbce462e2f935a566b))
ROM_END

ROM_START(drac_p11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-p11.rom", 0x00000, 0x80000, CRC(6eb2fc06) SHA1(62591adf5a3c3c9016462961e8f3d7c6f5125e45))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("dracsnd.u14", 0x000000, 0x80000, CRC(5137aaf5) SHA1(e6ee924e7e4718db0f7f315f2a6843e6f90afb41))
	ROM_LOAD("dracsnd.u15", 0x080000, 0x80000, CRC(77b5abe2) SHA1(e5622ae9ae0c1a0be886a1e5dc25b5a42c00c2ae))
	ROM_LOAD("dracsnd.u18", 0x100000, 0x80000, CRC(372ffb90) SHA1(89979670869c565d3ab86abbce462e2f935a566b))
ROM_END

/*-----------------
/  Creature from the Black Lagoon #20018
/------------------*/
ROM_START(cftbl_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("creat_l4.rom", 0x00000, 0x80000, CRC(b8778cb6) SHA1(a5dcc1ebedbd62d81e2e56fb8aebdc33fa6ba70c))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("bl_u14.l1", 0x000000, 0x80000, CRC(6b02bee4) SHA1(4f852b897dbf0ec2d5b17eed2ff70d9360b12213))
	ROM_LOAD("bl_u15.l1", 0x080000, 0x80000, CRC(15477d6f) SHA1(3ed7942828630bc9111d2e602fee931ef67db2ce))
	ROM_LOAD("bl_u18.l1", 0x100000, 0x20000, CRC(87267bcc) SHA1(3e733437bce3491c216a8627810897f6123f0679))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(cftbl_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("cftbl_l3.u6", 0x00000, 0x80000, CRC(11280230) SHA1(98ce0777cd7dc91d1d2b7016b2e44bdf60ec2c08))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("bl_u14.l1", 0x000000, 0x80000, CRC(6b02bee4) SHA1(4f852b897dbf0ec2d5b17eed2ff70d9360b12213))
	ROM_LOAD("bl_u15.l1", 0x080000, 0x80000, CRC(15477d6f) SHA1(3ed7942828630bc9111d2e602fee931ef67db2ce))
	ROM_LOAD("u18-sp1.rom", 0x100000, 0x20000, CRC(07198d93) SHA1(d91eb7ae7bd11340b0daf4edd2cd2e87acadeda4))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

/*-----------------
/  Doctor Who #20006
/------------------*/
ROM_START(dw_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("drwho_l2.rom", 0x00000, 0x80000, CRC(988c2deb) SHA1(e1f703a03f8fc594ae324c46ca77a54ead956094))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("dw_u14.l1", 0x000000, 0x80000, CRC(71f7d55b) SHA1(c3a22cfce2d10fe94a9749af7018e17e5e3bf4b3))
	ROM_LOAD("dw_u15.l1", 0x080000, 0x80000, CRC(9b87ff26) SHA1(483206ca0abdad4557843f83f245a1c20234af64))
	ROM_LOAD("dw_u18.l1", 0x100000, 0x20000, CRC(1ca78024) SHA1(e652b07e21b59c8c497a20dfddcb9ddd8cad228d))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(dw_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("dw_l1.u6", 0x00000, 0x80000, CRC(af8279af) SHA1(89651689156c0bf4abe35a538dc35c69f6575d4a))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("dw_u14.l1", 0x000000, 0x80000, CRC(71f7d55b) SHA1(c3a22cfce2d10fe94a9749af7018e17e5e3bf4b3))
	ROM_LOAD("dw_u15.l1", 0x080000, 0x80000, CRC(9b87ff26) SHA1(483206ca0abdad4557843f83f245a1c20234af64))
	ROM_LOAD("dw_u18.l1", 0x100000, 0x20000, CRC(1ca78024) SHA1(e652b07e21b59c8c497a20dfddcb9ddd8cad228d))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(dw_p5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("dw_p5.u6", 0x00000, 0x80000, CRC(2756a3ed) SHA1(ffeb2d303804c0a4ca4cbc2eb20b552529b5aabf))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("dw_u14.l1", 0x000000, 0x80000, CRC(71f7d55b) SHA1(c3a22cfce2d10fe94a9749af7018e17e5e3bf4b3))
	ROM_LOAD("dw_u15.l1", 0x080000, 0x80000, CRC(9b87ff26) SHA1(483206ca0abdad4557843f83f245a1c20234af64))
	ROM_LOAD("dw_u18.l1", 0x100000, 0x20000, CRC(1ca78024) SHA1(e652b07e21b59c8c497a20dfddcb9ddd8cad228d))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

/*-----------------
/  Fish Tales #50005
/------------------*/
ROM_START(ft_l5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("fshtl_5.rom", 0x00000, 0x80000, CRC(88847775) SHA1(ab323980b914678e1e3c9e2e4d92956e97dc32fa))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ft_u18.l1", 0x100000, 0x80000, CRC(48d2760a) SHA1(701b0bbb68f99332493ee1276e5a1cef5c85d499))
ROM_END

ROM_START(ft_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("ft-l3.u6", 0x00000, 0x80000, CRC(db1d3b4d) SHA1(a38afa42014140b566bc8923db9025ebdee16068))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ft_u18.l1", 0x100000, 0x80000, CRC(48d2760a) SHA1(701b0bbb68f99332493ee1276e5a1cef5c85d499))
ROM_END

ROM_START(ft_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("fshtl_4.rom", 0x00000, 0x80000, CRC(beb147b6) SHA1(543eea2e14283485221c1a28c3fdf3c87df8acc7))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ft_u18.l1", 0x100000, 0x80000, CRC(48d2760a) SHA1(701b0bbb68f99332493ee1276e5a1cef5c85d499))
ROM_END

ROM_START(ft_p4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("ft_p4.u6", 0x00000, 0x80000, CRC(386cbe45) SHA1(5cb4a32591121c4ed3da292fb50cec0d8d5dd44f))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ft_u18.l1", 0x100000, 0x80000, CRC(48d2760a) SHA1(701b0bbb68f99332493ee1276e5a1cef5c85d499))
ROM_END

/*-----------------
/  The Addams Family Special Collectors Edition #50038
/------------------*/
ROM_START(tafg_lx3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("afgldlx3.rom", 0x00000, 0x80000, CRC(0cc62fa5) SHA1(295bd8c483132c8fe7c38646847067041fc98b2f))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ag_u15_s.l1", 0x080000, 0x40000, CRC(b8c88c75) SHA1(b2b88e5192eb817ae60ab1f306e932d8bae3fbba))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ag_u18_s.l1", 0x100000, 0x80000, CRC(02e824a9) SHA1(ed8aa5161ea6c12cc9e646939290d848408a59a3))
ROM_END

ROM_START(tafg_h3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("cpu-u6h3.rom", 0x00000, 0x80000, CRC(2fe97098) SHA1(59767fce189385af16064abf0d640ef74a3450f8))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ag_u15_s.l1", 0x080000, 0x40000, CRC(b8c88c75) SHA1(b2b88e5192eb817ae60ab1f306e932d8bae3fbba))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ag_u18_s.l1", 0x100000, 0x80000, CRC(02e824a9) SHA1(ed8aa5161ea6c12cc9e646939290d848408a59a3))
ROM_END

ROM_START(tafg_la2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-la2.rom", 0x00000, 0x80000, CRC(a9a42bff) SHA1(40bb8e2767219582e7e532d2154213748808c62b))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ag_u15_s.l1", 0x080000, 0x40000, CRC(b8c88c75) SHA1(b2b88e5192eb817ae60ab1f306e932d8bae3fbba))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ag_u18_s.l1", 0x100000, 0x80000, CRC(02e824a9) SHA1(ed8aa5161ea6c12cc9e646939290d848408a59a3))
ROM_END

ROM_START(tafg_la3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-la3.rom", 0x00000, 0x80000, CRC(dbe4d791) SHA1(6906e9c2158e86ab05b6783567b42a245239fed9))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ag_u15_s.l1", 0x080000, 0x40000, CRC(b8c88c75) SHA1(b2b88e5192eb817ae60ab1f306e932d8bae3fbba))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ag_u18_s.l1", 0x100000, 0x80000, CRC(02e824a9) SHA1(ed8aa5161ea6c12cc9e646939290d848408a59a3))
ROM_END
/*-----------------
/  The Getaway: High Speed II #50004
/------------------*/
ROM_START(gw_l5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("getaw_l5.rom", 0x00000, 0x80000, CRC(b97f3d62) SHA1(c87c36a2327561c50b37d587d3bd0782acf8860d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18snd", 0x100000, 0x80000, CRC(37bbe485) SHA1(e6b7ccef250db0c801e3dd8ebf93522b466ca1ec))
ROM_END

ROM_START(gw_pb)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-p-b.rom", 0x00000, 0x80000, CRC(c2c76ce7) SHA1(bc5874f8012feaa92230415067b56f56aae109bc))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18-sp1.rom", 0x100000, 0x80000, CRC(fc5a5ff6) SHA1(bbe810135e05f81d1399ee0cb490ee93d6f9bb03))
ROM_END

ROM_START(gw_pc)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-p-c.rom", 0x00000, 0x80000, CRC(2bd887e6) SHA1(fe06307f5c9b19be9a889be7027a4b0f399b505f))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18-sp1.rom", 0x100000, 0x80000, CRC(fc5a5ff6) SHA1(bbe810135e05f81d1399ee0cb490ee93d6f9bb03))
ROM_END

ROM_START(gw_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("gw_l1.u6", 0x00000, 0x80000, CRC(cecf66cf) SHA1(f8286ee08402ce65b034e64fc777ead7bfe2fe13))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18snd", 0x100000, 0x80000, CRC(37bbe485) SHA1(e6b7ccef250db0c801e3dd8ebf93522b466ca1ec))
ROM_END

ROM_START(gw_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("get_l2.u6", 0x00000, 0x80000, CRC(9efc0005) SHA1(037ede538fb2c6f18980484528680fe90ccbb355))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18snd", 0x100000, 0x80000, CRC(37bbe485) SHA1(e6b7ccef250db0c801e3dd8ebf93522b466ca1ec))
ROM_END

ROM_START(gw_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("get_l3.u6", 0x00000, 0x80000, CRC(d10aaa44) SHA1(39ba198f9c4ce2419f8dbb8d90508e1beb524b5d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18snd", 0x100000, 0x80000, CRC(37bbe485) SHA1(e6b7ccef250db0c801e3dd8ebf93522b466ca1ec))
ROM_END

ROM_START(gw_p7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("gwhs2-p7.rom", 0x00000, 0x80000, CRC(5bef5cf6) SHA1(48f3e6ae3139eafde9752339d0713321e5a63bb1))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u18-sp1.rom", 0x100000, 0x80000, CRC(fc5a5ff6) SHA1(bbe810135e05f81d1399ee0cb490ee93d6f9bb03))
ROM_END
/*-----------------
/  Twilight Zone #50020
/------------------*/
ROM_START(tz_92)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tzone9_2.rom", 0x00000, 0x80000, CRC(ec3e61c8) SHA1(378c33add72c934aa2ee32e71830297ad1f08ce5))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_94h)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_94h.rom", 0x00000, 0x80000, CRC(5032e8c6) SHA1(d7481612b1c3040823e1f7b9e53ebbaa83de0532))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_94ch)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_94ch.rom", 0x00000, 0x80000, CRC(e3d3f3ef) SHA1(c2a856ffef84718382d840d9aa7ae41706fef1fd))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_l2.u6", 0x00000, 0x80000, CRC(1f0f5611) SHA1(e8860b1c288039682e56bbf8dd0c263b2632c4b7))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_l3.u6", 0x00000, 0x80000, CRC(c35fe03c) SHA1(44d2267ab278d092385e7ba21da8e6cbc2b69bf4))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_l4.u6", 0x00000, 0x80000, CRC(4baf5acd) SHA1(1edef7de6c3d24ef61e59b688d7b6871d88fd3b5))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_ifpa)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-ifpa.040", 0x00000, 0x80000, CRC(57f4c514) SHA1(17064a76e1037d439639ebbc9e64ca4fd1e5e62d))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_h7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-h7.040", 0x00000, 0x80000, CRC(84f29e46) SHA1(744c7e64418c8d95972470e4aafe42e96d2ea9cf))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_h8)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_h8.u6", 0x00000, 0x80000, CRC(f1b2d60c) SHA1(295fc07ae83f2cfbc84caf581915f99080fa397d))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l2.rom", 0x100000, 0x80000, CRC(66575ec2) SHA1(deceb56324ee9785946f5771f8cfbaf1b1d2c8bc))
ROM_END

ROM_START(tz_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-l1.040", 0x00000, 0x80000, CRC(6db6ae06) SHA1(a0e15c5f5e94391c3f0e77155307c3aacba1aff9))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("tzu14_l2.rom", 0x000000, 0x20000, CRC(5a67bd56) SHA1(98669fbfdc5793bcf09fe72c231e2b4fa2524cc5))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("tzu15_l2.rom", 0x080000, 0x80000, CRC(389d2442) SHA1(58a4bc7cc7a28b47c75d5c9bbf14abf34bd7a9e3))
	ROM_LOAD("tzu18_l1.rom", 0x100000, 0x80000, CRC(a021a494) SHA1(27bbb60fce2892b1b0b611687a1ac59c7c668f9d))
ROM_END

ROM_START(tz_pa1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-pa1.040", 0x00000, 0x80000, CRC(c34e06a6) SHA1(09c8097a54fdc15de7ee3e3eb5b12952c0bf5eaf))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u14-sp1.040", 0x000000, 0x80000, CRC(ad7cb98b) SHA1(a84bf157cb535acaf811e93ad22a505e1dd08dad))
	ROM_LOAD("u15-sp1.040", 0x080000, 0x80000, CRC(0f17c9e9) SHA1(fcaa6f87ebd03222e3a40be08eb5aa6a5e002a8b))
	ROM_LOAD("u18-sp1.040", 0x100000, 0x80000, CRC(1632951e) SHA1(041396411dc5343fe7e5147d26e038de79982464))
ROM_END

ROM_START(tz_p3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_p3.bin", 0x00000, 0x80000, CRC(f3b1fd9f) SHA1(aa551fc6638e79edf10fbe89127c55372cc3cb58))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u14-sp1.040", 0x000000, 0x80000, CRC(ad7cb98b) SHA1(a84bf157cb535acaf811e93ad22a505e1dd08dad))
	ROM_LOAD("u15-sp1.040", 0x080000, 0x80000, CRC(0f17c9e9) SHA1(fcaa6f87ebd03222e3a40be08eb5aa6a5e002a8b))
	ROM_LOAD("tzu18_p3.rom", 0x100000, 0x80000, CRC(1f750672) SHA1(033c6e261201a17667110069b7570fe90490286b))
ROM_END

ROM_START(tz_p4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("tz_p4.rom", 0x00000, 0x80000, CRC(5a662df5) SHA1(0f609ff59549225d56b913c3bf928b58f7bf1ca5))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("u14-sp1.040", 0x000000, 0x80000, CRC(ad7cb98b) SHA1(a84bf157cb535acaf811e93ad22a505e1dd08dad))
	ROM_LOAD("u15-sp1.040", 0x080000, 0x80000, CRC(0f17c9e9) SHA1(fcaa6f87ebd03222e3a40be08eb5aa6a5e002a8b))
	ROM_LOAD("tzu18_p3.rom", 0x100000, 0x80000, CRC(1f750672) SHA1(033c6e261201a17667110069b7570fe90490286b))
ROM_END

/*-----------------
/  White Water #50018
/------------------*/
ROM_START(ww_l5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("wwatr_l5.rom", 0x00000, 0x80000, CRC(4eb1d233) SHA1(b4eda04221e11697a7c5924c37622221fe4a47d0))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_lh5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "code", 0)
	ROM_LOAD("ww_lh5.rom", 0x00000, 0x100000, CRC(5e03a182) SHA1(0a988d8e1b2b9ed9d6b012634f2b3eede5673600))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_lh6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "code", 0)
	ROM_LOAD("ww_lh6.rom", 0x00000, 0x100000, CRC(bb1465cf) SHA1(2e554b0d3ceca46c6eb8852534c140916a16069d))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-l4.rom", 0x00000, 0x80000, CRC(59c2def3) SHA1(99fe53f228d3e4047958ec263e92926891ea7594))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("u6-l3.rom", 0x00000, 0x80000, CRC(b8ff04d9) SHA1(a7b16306bf050ee961490abfaf904b1800bfbc3e))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("ww_l2.u6", 0x00000, 0x80000, CRC(2738acf8) SHA1(1554dd497d6aae53934e2e4a2e42bda1f87aaa02))
	ROM_REGION(0x180000, "sound1",0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.l1", 0x080000, 0x40000, CRC(fe1ae71b) SHA1(8898a56866448728e7f81338ce8ad2e8cc6c7370))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.l1", 0x100000, 0x20000, CRC(6f483215) SHA1(03053a16c106ccc7aa5a1206eb1da3f5f05ed38f))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_p8)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("ww_p8.u6", 0x00000, 0x80000, CRC(251a7f14) SHA1(8e36efc9a14d3cd31967f072bfc185461022864d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.p2", 0x080000, 0x40000, CRC(8eb9033f) SHA1(9a4e269733d6ae58bf30b8b293ecb0b10dbcc8b3))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.p2", 0x100000, 0x20000, CRC(7a9ace30) SHA1(996cb73504ef73675c596e6f811047f16fbff0dd))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

ROM_START(ww_p1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("ww_p8.u6", 0x00000, 0x80000, CRC(251a7f14) SHA1(8e36efc9a14d3cd31967f072bfc185461022864d))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("ww_u14.l1", 0x000000, 0x80000, CRC(f3faa427) SHA1(fb0a266b80571b4717caa69f078b7e73e2866b6b))
	ROM_LOAD("ww_u15.p1", 0x080000, 0x40000, CRC(a2a8e005) SHA1(bdbfc3f6c403d1ebef822a6381574f4a7bd19897))
	ROM_RELOAD( 0x080000 + 0x40000, 0x40000)
	ROM_LOAD("ww_u18.p1", 0x100000, 0x20000, CRC(e0e51ea6) SHA1(819133d55a48ea84b6d8d0dfd1316f28919361cc))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

/*-------------------
/ Strike Master (Shuffle Alley)
/--------------------*/
ROM_START(strik_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x40000, "code", 0)
	ROM_LOAD("strik_l4.rom", 0x00000, 0x40000, CRC(c99ea24c) SHA1(f8b083adcbabdc70a1bf7c87c9b488eca7b1c788))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("lc_u14.l1", 0x000000, 0x20000, CRC(7b6dd395) SHA1(fdb01f70bb5f1a4ada9805770e544c4a191ddf26))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("lc_u15.l1", 0x080000, 0x20000, CRC(25fe0be3) SHA1(a784b99daab1255487d4cb05d008a8aee0c39b30))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("lc_u18.l1", 0x100000, 0x20000, CRC(beb84fd9) SHA1(b1d5472af5e3c0f5c67e7d636122eb79e02494ba))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END

/*-----------------------------
/ League Champ (Shuffle Alley)
/------------------------------*/
ROM_START(lc_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "code", 0)
	ROM_LOAD("lchmp1_1.rom", 0x00000, 0x80000, CRC(60ab944c) SHA1(d2369b0a864e864b269de1765121e4534fa8fa59))
	ROM_REGION(0x180000, "sound1", 0)
	ROM_LOAD("lc_u14.l1", 0x000000, 0x20000, CRC(7b6dd395) SHA1(fdb01f70bb5f1a4ada9805770e544c4a191ddf26))
	ROM_RELOAD( 0x000000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x000000 + 0x60000, 0x20000)
	ROM_LOAD("lc_u15.l1", 0x080000, 0x20000, CRC(25fe0be3) SHA1(a784b99daab1255487d4cb05d008a8aee0c39b30))
	ROM_RELOAD( 0x080000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x080000 + 0x60000, 0x20000)
	ROM_LOAD("lc_u18.l1", 0x100000, 0x20000, CRC(beb84fd9) SHA1(b1d5472af5e3c0f5c67e7d636122eb79e02494ba))
	ROM_RELOAD( 0x100000 + 0x20000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x40000, 0x20000)
	ROM_RELOAD( 0x100000 + 0x60000, 0x20000)
ROM_END


GAME(1993,  br_l4,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Black Rose (L-4)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  br_p17,     br_l4,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Black Rose (SP-1)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  br_l1,      br_l4,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Black Rose (L-1)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  br_l3,      br_l4,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Black Rose (L-3)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  drac_l1,    0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Bram Stoker's Dracula (L-1)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  drac_p11,   drac_l1,    wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Bram Stoker's Dracula (P-11)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  cftbl_l4,   0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Creature from the Black Lagoon (L-4)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  cftbl_l3,   cftbl_l4,   wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Creature from the Black Lagoon (L-3,SP-1)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  dw_l2,      0,          wpc_flip2,  wpc_dw, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Doctor Who (L-2)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  dw_l1,      dw_l2,      wpc_flip2,  wpc_dw, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Doctor Who (L-1)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  dw_p5,      dw_l2,      wpc_flip2,  wpc_dw, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Doctor Who (P-5)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ft_l5,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Fish Tales (L-5)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ft_l3,      ft_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Fish Tales (L-3)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ft_l4,      ft_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Fish Tales (L-4)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ft_p4,      ft_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Fish Tales (P-4)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tafg_lx3,   0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "The Addams Family Special Collectors Edition Gold (LX-3)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tafg_h3,    tafg_lx3,   wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "The Addams Family Special Collectors Edition (H-3)",               MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tafg_la2,   tafg_lx3,   wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "The Addams Family Special Collectors Edition (LA-2)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tafg_la3,   tafg_lx3,   wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "The Addams Family Special Collectors Edition (LA-3)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_l5,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (L-5)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_pb,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (P-B)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_pc,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (P-C)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_l1,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (L-1)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_l2,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (L-2)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_l3,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (L-3)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  gw_p7,      gw_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "The Getaway: High Speed II (P-7)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1998,  tz_92,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (9.2)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1998,  tz_94h,     tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (9.4H)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1998,  tz_94ch,    tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (9.4CH)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_pa1,     tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (PA-1)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_p3,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (P-3)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_p4,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (P-4)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_l1,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (L-1)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_l2,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (L-2)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_ifpa,    tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (IFPA rules)",               MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_l3,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (L-3)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  tz_l4,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (L-4)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tz_h7,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (H-7)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1994,  tz_h8,      tz_92,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "Twilight Zone (H-8)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(2000,  ww_l5,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (L-5)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(2000,  ww_lh6,     ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (LH-6)",               MACHINE_IS_SKELETON_MECHANICAL)
GAME(2000,  ww_lh5,     ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (LH-5)",               MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  ww_l4,      ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (L-4)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1993,  ww_l3,      ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (L-3)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ww_l2,      ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (L-2)",                MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ww_p8,      ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (P-8 P-2 sound)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  ww_p1,      ww_l5,      wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "White Water (P-8 P-1 sound)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1992,  strik_l4,   0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Williams",             "Strike Master (L-4)",              MACHINE_IS_SKELETON_MECHANICAL)
GAME(1996,  lc_11,      0,          wpc_flip2,  wpc_flip2, wpc_flip2_state, wpc_flip2,  ROT0,   "Bally",                "League Champ (1.1)",               MACHINE_IS_SKELETON_MECHANICAL)
