// license:BSD-3-Clause
// copyright-holders:Curt Coder
/**********************************************************************

    CST Q+4 emulation

**********************************************************************/

#ifndef MAME_BUS_QL_CST_Q_PLUS4_H
#define MAME_BUS_QL_CST_Q_PLUS4_H

#pragma once

#include "exp.h"
#include "machine/6821pia.h"



//**************************************************************************
//  TYPE DEFINITIONS
//**************************************************************************

// ======================> cst_q_plus4_device

class cst_q_plus4_device : public device_t, public device_ql_expansion_card_interface
{
public:
	// construction/destruction
	cst_q_plus4_device(const machine_config &mconfig, const char *tag, device_t *owner, uint32_t clock);

	// optional information overrides
	virtual const tiny_rom_entry *device_rom_region() const override;
	virtual machine_config_constructor device_mconfig_additions() const override;

	DECLARE_WRITE_LINE_MEMBER( exp1_extintl_w ) { m_exp1_extinl = state; update_extintl(); }
	DECLARE_WRITE_LINE_MEMBER( exp2_extintl_w ) { m_exp2_extinl = state; update_extintl(); }
	DECLARE_WRITE_LINE_MEMBER( exp3_extintl_w ) { m_exp3_extinl = state; update_extintl(); }
	DECLARE_WRITE_LINE_MEMBER( exp4_extintl_w ) { m_exp4_extinl = state; update_extintl(); }

protected:
	// device-level overrides
	virtual void device_start() override;

	// device_ql_expansion_card_interface overrides
	virtual uint8_t read(address_space &space, offs_t offset, uint8_t data) override;
	virtual void write(address_space &space, offs_t offset, uint8_t data) override;

private:
	void update_extintl() { m_slot->extintl_w(m_exp1_extinl || m_exp2_extinl || m_exp3_extinl || m_exp4_extinl); }

	required_device<ql_expansion_slot_device> m_exp1;
	required_device<ql_expansion_slot_device> m_exp2;
	required_device<ql_expansion_slot_device> m_exp3;
	required_device<ql_expansion_slot_device> m_exp4;
	required_memory_region m_rom;

	int m_exp1_extinl;
	int m_exp2_extinl;
	int m_exp3_extinl;
	int m_exp4_extinl;
};


// device type definition
DECLARE_DEVICE_TYPE(CST_Q_PLUS4, cst_q_plus4_device)

#endif // MAME_BUS_QL_CST_Q_PLUS4_H
